package com.huigou.topsun.sap.exceptionReport.application.impl;

import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.data.query.model.QueryModel;
import com.huigou.topsun.sap.exceptionReport.application.ExceptionReportDutyPersonApplication;
import com.huigou.topsun.sap.exceptionReport.domain.ExceptionReportDutyPerson;
import com.huigou.topsun.sap.exceptionReport.domain.query.ExceptionReportQueryRequest;
import com.huigou.topsun.sap.exceptionReport.repository.ExceptionReportDutyPersonRepository;
import com.huigou.uasp.bmp.common.application.BaseApplication;
import com.huigou.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Auther: xin.lu
 * @Date: 2024/03/20/19:36
 * @Description: 品质异常报告责任人信息
 */
@Service("exceptionReportDutyPersonApplication")
public class ExceptionReportDutyPersonApplicationImpl extends BaseApplication implements ExceptionReportDutyPersonApplication {
    @Autowired
    private ExceptionReportDutyPersonRepository exceptionReportDutyPersonRepository;
    @Override
    public List<ExceptionReportDutyPerson> findByExceptionReportId(String exceptionReportId) {
        return exceptionReportDutyPersonRepository.findByExceptionReportId(exceptionReportId);
    }

    @Override
    public void saveExceptionReportDutyPersonList(String exceptionReportId, List<ExceptionReportDutyPerson> personList) {
        for (ExceptionReportDutyPerson exceptionReportDutyPerson : personList) {
            exceptionReportDutyPerson.setExceptionReportId(exceptionReportId);
            exceptionReportDutyPersonRepository.save(exceptionReportDutyPerson);
        }
    }

    @Override
    public Map<String, Object> slicedExceptionReportDutyPersonList(ExceptionReportQueryRequest queryRequest) {
        Map<String, Object> map = new HashMap<>();
        if (StringUtil.isNotBlank(queryRequest.getExceptionReportId())){
            QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "exceptionReportDutyPersons");
            QueryModel queryModel = this.sqlExecutorDao.getQueryModel(queryDescriptor, queryRequest);
            map = this.sqlExecutorDao.executeSlicedQuery(queryModel);
        }
        return map;
    }

    @Override
    public void deleteByIds(List<String> ids) {
        for (String id : ids) {
            exceptionReportDutyPersonRepository.delete(id);
        }
    }

    @Override
    public void saveExceptionReportDutyPerson(ExceptionReportDutyPerson exceptionReportDutyPerson) {
        exceptionReportDutyPersonRepository.save(exceptionReportDutyPerson);
    }
}
