package com.huigou.topsun.sap.exceptionReport.application;

import com.huigou.topsun.sap.exceptionReport.domain.ExceptionReport;
import com.huigou.topsun.sap.exceptionReport.domain.query.ExceptionReportQueryRequest;

import javax.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.util.List;
import java.util.Map;

/**
 * @Auther: xin.lu
 * @Date: 2024/03/20/19:36
 * @Description:
 */
public interface ExceptionReportApplication {
    public static final String QUERY_XML_FILE_PATH = "config/topsun/sap/exceptionReport/exceptionReport.xml";

    String PROCESS_DEFINITION_KEY = "exceptionReportProc";

    Map<String,Object> slicedExceptionReportList(ExceptionReportQueryRequest queryRequest);
    Map<String,Object> slicedExceptionReportExportList(ExceptionReportQueryRequest queryRequest);

    ExceptionReport findById(String id);

    void deleteById(String id);

    ExceptionReport saveExceptionReport(ExceptionReport exceptionReport);

    ByteArrayOutputStream printInfo(HttpServletResponse response, String id);

    List<Map<String,Object>> getCustomerOrders(String customerNo);

    String getResponsibleTimes(String id);
}
