package com.huigou.topsun.sap.costCenter.domain.vo;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import javax.persistence.Column;
import java.math.BigDecimal;

/**
 * title:
 * author:ZHT
 * date:2024/1/8
 * description:
 *  成本中心SAP返回消息封装类
 */
@Data
public class CostCenterMessageVo {
    /**
     * 消息类型: S 成功,E 错误,W 警告,I 信息,A 中断
     */
    @Column(name = "TYPE")
    @JsonProperty("TYPE")
    private String TYPE;
    /**
     * 消息类__ID
     */
    @Column(name = "message_id")
    @JsonProperty("ID")
    private String messageId;
    /**
     * 消息编号
     */
    @Column(name = "NUMBER")
    @JsonProperty("NUMBER")
    private BigDecimal NUMBER;
    /**
     * 消息文本
     */
    @Column(name = "MESSAGE")
    @JsonProperty("MESSAGE")
    private String MESSAGE;
    /**
     * 应用程序日志,日志号
     */
    @Column(name = "LOG_NO")
    @JsonProperty("LOG_NO")
    private String LOG_NO;

    /**
     * 行
     */
    private String ROW;
}
