package com.huigou.topsun.sap.cashSettlementUnPay.application.impl;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.data.query.model.QueryModel;
import com.huigou.topsun.sap.cashSettlementUnPay.application.CashSettlementUnPayItemDetailApplication;
import com.huigou.topsun.sap.cashSettlementUnPay.domain.CashSettlementUnPayItemDetail;
import com.huigou.topsun.sap.cashSettlementUnPay.domain.query.CashSettlementUnPayQueryRequest;
import com.huigou.topsun.sap.cashSettlementUnPay.repository.CashSettlementUnPayItemDetailRepository;
import com.huigou.topsun.sap.cashSettlementUnPay.vo.CashSettlementUnPayItemDetailVo;
import com.huigou.topsun.sap.cashSettlementUnPay.vo.CashSettlementUnPayItemVo;
import com.huigou.topsun.sap.common.HttpClient;
import com.huigou.topsun.util.SAPUtils;
import com.huigou.uasp.bmp.common.application.BaseApplication;
import com.huigou.util.JSONUtil;
import com.huigou.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Auther: LXH
 * @Date: 2024/03/26/10:16
 * @Description:
 */
@Service("cashSettlementUnPayItemDetailApplication")
public class CashSettlementUnPayItemDetailApplicationImpl extends BaseApplication implements CashSettlementUnPayItemDetailApplication {
    @Autowired
    private CashSettlementUnPayItemDetailRepository cashSettlementUnPayItemDetailRepository;
    @Autowired
    private HttpClient httpClient;
    @Override
    public void saveCashSettlementUnPayItemDetails(String CashSettlementUnPayId, List<CashSettlementUnPayItemDetail> items) {
        for (CashSettlementUnPayItemDetail item : items) {
            item.setCashSettlementUnPayItemId(CashSettlementUnPayId);
            cashSettlementUnPayItemDetailRepository.save(item);
        }
    }

    @Override
    public void saveCashSettlementUnPayItemDetail(CashSettlementUnPayItemDetail detail) {
        cashSettlementUnPayItemDetailRepository.save(detail);
    }

    @Override
    public Map<String, Object> queryCashSettlementUnPayItemDetails(CashSettlementUnPayQueryRequest queryRequest) {
        Map<String, Object> map = new HashMap<>();
        if (StringUtil.isNotBlank(queryRequest.getCashSettlementUnPayId())){
            QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "cashSettlementUnPayItemDetails");
            QueryModel queryModel = this.sqlExecutorDao.getQueryModel(queryDescriptor, queryRequest);
            map = this.sqlExecutorDao.executeSlicedQuery(queryModel);
        }
        return map;
    }

    @Override
    public void deleteByCashSettlementUnPayItemId(String cashSettlementUnPayItemId) {
        List<CashSettlementUnPayItemDetail> detailList = cashSettlementUnPayItemDetailRepository.findByCashSettlementUnPayItemId(cashSettlementUnPayItemId);
        cashSettlementUnPayItemDetailRepository.delete(detailList);
    }

    @Override
    public List<CashSettlementUnPayItemDetail> findByCashSettlementUnPayItemId(String cashSettlementUnPayItemId) {
        return cashSettlementUnPayItemDetailRepository.findByCashSettlementUnPayItemId(cashSettlementUnPayItemId);
    }

    @Override
    public List<CashSettlementUnPayItemDetailVo> getItemDetailsByAdvanceReceiptNo(String advanceReceiptNo) {
        Map<String, Object> map = new HashMap<>();
        List<CashSettlementUnPayItemDetailVo> detailVoList = new ArrayList<>();
        if (StringUtil.isNotBlank(advanceReceiptNo)){
            List<Map<String,String>> paramList = new ArrayList<>();
            Map<String,String> paramMap = new HashMap<>();
            paramMap.put("ZCRPNR",advanceReceiptNo);
            paramList.add(paramMap);
            String execute = "";
            try {
                execute = httpClient.execute(paramList, "get_ap_note");
                ObjectMapper objectMapper = SAPUtils.objectMapper();
                List<Map<String ,Object>> mapList = objectMapper.readValue(execute, new TypeReference<List<Map<String,Object>>>() {});
                if (!CollectionUtils.isEmpty(mapList)){
                    map = mapList.get(0);
                    String zcrpnr = (String) map.get("ZCRPNR");
                    if (!"E".equals(map.get("TYPE"))){
                        Object ztbApDel = map.get("ZTB_AP_DEL");
                        String string = JSONUtil.toString(ztbApDel);
                        detailVoList = objectMapper.readValue(string, new TypeReference<List<CashSettlementUnPayItemDetailVo>>() {});
                        detailVoList.forEach(item -> item.setAdvanceReceiptNo(zcrpnr));
                    }
                }
            } catch (IOException e) {
                throw new RuntimeException(String.format("根据预收单号查询“%s“销售单信息出错。", advanceReceiptNo));
            }
        }
        return detailVoList;
    }

    @Override
    public CashSettlementUnPayItemVo getItemByAdvanceReceiptNo(String advanceReceiptNo) {
        CashSettlementUnPayItemVo vo = new CashSettlementUnPayItemVo();
        if (StringUtil.isNotBlank(advanceReceiptNo)){
            List<Map<String,String>> paramList = new ArrayList<>();
            Map<String,String> paramMap = new HashMap<>();
            paramMap.put("ZCRPNR",advanceReceiptNo);
            paramList.add(paramMap);
            String execute = "";
            try {
                execute = httpClient.execute(paramList, "get_ap_note");
                ObjectMapper objectMapper = SAPUtils.objectMapper();
                List<CashSettlementUnPayItemVo> voList = objectMapper.readValue(execute, new TypeReference<List<CashSettlementUnPayItemVo>>() {});
                if (!CollectionUtils.isEmpty(voList)){
                    vo = voList.get(0);
                }
            } catch (IOException e) {
                throw new RuntimeException(String.format("根据预收单号查询“%s“销售单信息出错。", advanceReceiptNo));
            }
        }
        return vo;
    }

    @Override
    public List<CashSettlementUnPayItemDetailVo> getItemDetailsByAdvanceReceiptNoOrSaleNo(String advanceReceiptNo, String saleNo) {
        Map<String, Object> map = new HashMap<>();
        List<CashSettlementUnPayItemDetailVo> detailVoList = new ArrayList<>();
        if (StringUtil.isNotBlank(advanceReceiptNo) || StringUtil.isNotBlank(saleNo)){
            List<Map<String,String>> paramList = new ArrayList<>();
            Map<String,String> paramMap = new HashMap<>();
            paramMap.put("ZCRPNR",advanceReceiptNo);
            paramMap.put("VGBEL",saleNo);
            paramList.add(paramMap);
            String execute = "";
            try {
                execute = httpClient.execute(paramList, "get_ap_item");
                ObjectMapper objectMapper = SAPUtils.objectMapper();
                Map<String, Object> objectMap = JSONUtil.toMap(execute);
                String rdata = JSONUtil.toString(objectMap.get("RDATA"));
                List<Map<String ,Object>> mapList = objectMapper.readValue(rdata, new TypeReference<List<Map<String,Object>>>() {});
                if (!CollectionUtils.isEmpty(mapList)){
                    map = mapList.get(0);
                    String zcrpnr = (String) map.get("ZCRPNR");
                    if (!"E".equals(map.get("TYPE"))){
                        Object ztbApDel = map.get("ZTB_AP_DEL");
                        String string = JSONUtil.toString(ztbApDel);
                        detailVoList = objectMapper.readValue(string, new TypeReference<List<CashSettlementUnPayItemDetailVo>>() {});
                        detailVoList.forEach(item -> item.setAdvanceReceiptNo(zcrpnr));
                    }
                }
            } catch (IOException e) {
                throw new RuntimeException(String.format("根据预收单号查询“%s“销售单信息出错。", advanceReceiptNo));
            }
        }
        return detailVoList;
    }

    @Override
    public List<Map<String, String>>  getAdvanceReceiptNo(String customerCode) {
        List<Map<String, String>>  mapList = new ArrayList<>();
        if (StringUtil.isNotBlank(customerCode) ){
            List<Map<String,String>> paramList = new ArrayList<>();
            Map<String,String> paramMap = new HashMap<>();
            paramMap.put("ZCRPTITLE",customerCode);
            paramList.add(paramMap);
            String execute = "";
            try {
                execute = httpClient.execute(paramList, "get_ap_zcrpnr");
                ObjectMapper objectMapper = SAPUtils.objectMapper();
                Map<String, Object> objectMap = JSONUtil.toMap(execute);
                String rdata = JSONUtil.toString(objectMap.get("RDATA"));
                mapList = objectMapper.readValue(rdata, new TypeReference<List<Map<String, String>> >() {});
            } catch (IOException e) {
                throw new RuntimeException(String.format("根据客户查询“%s“预收单信息出错。", customerCode));
            }
        }
        return mapList;
    }
}
