package com.huigou.topsun.sap.cashSettlementUnPay.application.impl;

import cn.hutool.core.util.ObjectUtil;
import com.huigou.cache.DictUtil;
import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.data.query.model.QueryModel;
import com.huigou.topsun.sap.cashSettlementUnPay.application.CashSettlementUnPayItemApplication;
import com.huigou.topsun.sap.cashSettlementUnPay.application.CashSettlementUnPayItemDetailApplication;
import com.huigou.topsun.sap.cashSettlementUnPay.domain.CashSettlementUnPayItem;
import com.huigou.topsun.sap.cashSettlementUnPay.domain.CashSettlementUnPayItemDetail;
import com.huigou.topsun.sap.cashSettlementUnPay.domain.query.CashSettlementUnPayQueryRequest;
import com.huigou.topsun.sap.cashSettlementUnPay.repository.CashSettlementUnPayItemRepository;
import com.huigou.topsun.sap.cashSettlementUnPay.vo.CashSettlementUnPayItemDetailVo;
import com.huigou.topsun.sap.cashSettlementUnPay.vo.CashSettlementUnPayItemVo;
import com.huigou.uasp.bmp.common.application.BaseApplication;
import com.huigou.util.ClassHelper;
import com.huigou.util.StringUtil;
import org.apache.cxf.common.util.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @Auther: LXH
 * @Date: 2024/03/26/10:16
 * @Description:
 */
@Service("CashSettlementUnPayApplicationItemApplication")
public class CashSettlementUnPayItemApplicationImpl extends BaseApplication implements CashSettlementUnPayItemApplication {
    @Autowired
    private CashSettlementUnPayItemRepository cashSettlementUnPayItemRepository;
    @Autowired
    private CashSettlementUnPayItemDetailApplication cashSettlementUnPayItemDetailApplication;
    @Override
    public void saveCashSettlementUnPayItems(String CashSettlementUnPayId, List<CashSettlementUnPayItem> items) {
        for (CashSettlementUnPayItem item : items) {
            item.setCashSettlementUnPayId(CashSettlementUnPayId);
            CashSettlementUnPayItemVo unPayItemVo = cashSettlementUnPayItemDetailApplication.getItemByAdvanceReceiptNo(item.getAdvanceReceiptNo());
            if (ObjectUtil.isNotNull(unPayItemVo)){
                item.setPayStatus(unPayItemVo.getPayStatus());
                item.setWaerk(unPayItemVo.getWaerk());
                item.setZcusdisc(unPayItemVo.getZcusdisc());
                item.setZaddprc(unPayItemVo.getZaddprc());
                item.setMonat(unPayItemVo.getMonat());
                item.setZf15(unPayItemVo.getZf15());
                item.setZf14(unPayItemVo.getZf14());
                item.setZcrpnote(unPayItemVo.getZcrpnote());
                item.setKukla(unPayItemVo.getKukla());
            }
            List<CashSettlementUnPayItemDetailVo> itemDetailVoList = new ArrayList<>();
            if (StringUtil.isBlank(item.getId())){
                itemDetailVoList = cashSettlementUnPayItemDetailApplication.getItemDetailsByAdvanceReceiptNo(item.getAdvanceReceiptNo());
            }
            cashSettlementUnPayItemRepository.save(item);
            if (!CollectionUtils.isEmpty(itemDetailVoList)){
                List<CashSettlementUnPayItemDetail> detailList = new ArrayList<>();
                for (CashSettlementUnPayItemDetailVo itemDetailVo : itemDetailVoList) {
                    CashSettlementUnPayItemDetail cashSettlementUnPayItemDetail = new CashSettlementUnPayItemDetail();
                    ClassHelper.copyProperties(itemDetailVo, cashSettlementUnPayItemDetail);
                    cashSettlementUnPayItemDetail.setCashSettlementUnPayItemId(item.getId());
                    detailList.add(cashSettlementUnPayItemDetail);
                }
                cashSettlementUnPayItemDetailApplication.saveCashSettlementUnPayItemDetails(item.getId(), detailList);
            }
        }
    }

    @Override
    public Map<String, Object> queryCashSettlementUnPayItems(CashSettlementUnPayQueryRequest queryRequest) {
        Map<String, Object> map = new HashMap<>();
        if (StringUtil.isNotBlank(queryRequest.getCashSettlementUnPayId())){
            QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "cashSettlementUnPayItems");
            QueryModel queryModel = this.sqlExecutorDao.getQueryModel(queryDescriptor, queryRequest);
            map = this.sqlExecutorDao.executeSlicedQuery(queryModel);
        }
        return map;
    }

    @Override
    public void deleteByIds(List<String> ids) {
        ids.forEach(id->{
            cashSettlementUnPayItemDetailApplication.deleteByCashSettlementUnPayItemId(id);
            cashSettlementUnPayItemRepository.delete(id);
        });
    }

    @Override
    public List<CashSettlementUnPayItem> findByCashSettlementUnPayId(String CashSettlementUnPayId) {
        return cashSettlementUnPayItemRepository.findByCashSettlementUnPayId(CashSettlementUnPayId);
    }

    @Override
    public void updateCashSettlementUnPayItem(String id, String advanceReceiptNo) {
        //先删除，再新增
        cashSettlementUnPayItemDetailApplication.deleteByCashSettlementUnPayItemId(id);

        List<CashSettlementUnPayItemDetailVo> itemDetailVoList = cashSettlementUnPayItemDetailApplication.getItemDetailsByAdvanceReceiptNo(advanceReceiptNo);
        if (ObjectUtil.isNotNull(itemDetailVoList)){
            List<CashSettlementUnPayItemDetail> detailList = itemDetailVoList.stream().map(itemDetailVo -> {
                CashSettlementUnPayItemDetail cashSettlementUnPayItemDetail = new CashSettlementUnPayItemDetail();
                ClassHelper.copyProperties(itemDetailVo, cashSettlementUnPayItemDetail);
                return cashSettlementUnPayItemDetail;
            }).collect(Collectors.toList());
            cashSettlementUnPayItemDetailApplication.saveCashSettlementUnPayItemDetails(id, detailList);
        }
    }
}
