package com.huigou.topsun.common;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;

import java.io.IOException;

/**
 * NumberToStringSerializer Jackson 数据类型转换
 *
 * @author qinzhenguan
 * @createDate 2023/12/20 10:12
 **/
public class NumberToStringSerializer extends JsonSerializer<Number> {
    @Override
    public void serialize(Number number, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeString(number.toString());
    }
}