package com.huigou.tech.common.domain.model;

import java.util.Date;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;

import org.springframework.util.Assert;

import com.huigou.data.domain.model.AbstractEntity;
import com.huigou.tech.common.domain.TechNoticeKind;
import com.huigou.util.DateUtil;

/**
 * 通知任务主表
 * TECH_NOTICE
 * 
 * @date 2017-11-29 14:56
 */
@Entity
@Table(name = "TECH_NOTICE")
public class Notice extends AbstractEntity {

    private static final long serialVersionUID = -6103200502997322793L;

    @Column(name = "name", length = 256)
    private String name;

    /**
     * 标题
     **/
    @Column(name = "subject", length = 512)
    private String subject;

    /**
     * 内容
     **/
    @Column(name = "content", length = 3072)
    private String content;

    /**
     * URL
     **/
    @Column(name = "url", length = 256)
    private String url;

    /**
     * 通知类型
     **/
    @Column(name = "notice_kind", length = 64)
    private String noticeKind;

    /**
     * 流程业务编码
     **/
    @Column(name = "process_code", length = 64)
    private String processCode;

    /**
     * 流程ID
     **/
    @Column(name = "biz_id", length = 64)
    private String bizId;

    /**
     * 通知人员IDs
     **/
    @Column(name = "executor_ids", length = 2048)
    private String executorIds;

    /**
     * 通知人员数量
     **/
    @Column(name = "executor_count", length = 22)
    private Integer executorCount;

    /**
     * 创建时间
     **/
    @Column(name = "created_date", length = 7)
    private Date createdDate;

    @Transient
    private String currentTaskId;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getNoticeKind() {
        return noticeKind;
    }

    public void setNoticeKind(String noticeKind) {
        this.noticeKind = noticeKind;
    }

    public String getProcessCode() {
        return processCode;
    }

    public void setProcessCode(String processCode) {
        this.processCode = processCode;
    }

    public String getBizId() {
        return bizId;
    }

    public void setBizId(String bizId) {
        this.bizId = bizId;
    }

    public String getExecutorIds() {
        return executorIds;
    }

    public void setExecutorIds(String executorIds) {
        this.executorIds = executorIds;
    }

    public Integer getExecutorCount() {
        return executorCount;
    }

    public void setExecutorCount(Integer executorCount) {
        this.executorCount = executorCount;
    }

    public Date getCreatedDate() {
        return createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public String getCurrentTaskId() {
        return currentTaskId;
    }

    public void setCurrentTaskId(String currentTaskId) {
        this.currentTaskId = currentTaskId;
    }

    /**
     * 设置人员信息，及创建时间；
     * 
     * @param executorIds
     */
    public void putInitExecutorData(List<String> executorIds) {
        // 设置创建时间；
        this.createdDate = DateUtil.getTimestamp();
        // 设置通知人数
        int executorCount = executorIds.size();
        this.executorCount = executorCount;
        // 只记录第一个通知的人员ID信息
        if (executorCount > 0) {
            this.executorIds = executorIds.get(0);
        }
    }

    public void checkConstraints() {
        Assert.hasText(this.name, "名称不能为空!");
        Assert.hasText(this.subject, "标题不能为空!");
        Assert.hasText(this.noticeKind, "通知类型不能为空!");
        TechNoticeKind kind = TechNoticeKind.fromId(this.noticeKind);
        if (kind == TechNoticeKind.CHART) {
            Assert.hasText(this.processCode, "流程图编码不能为空!");
        } else if (kind == TechNoticeKind.IFRAME || kind == TechNoticeKind.LOAD) {
            Assert.hasText(this.url, "URL不能为空!");
        } else if (kind == TechNoticeKind.TEXT) {
            Assert.hasText(this.content, "内容不能为空!");
        }
    }
}
