var gridManager = null;

$(document).ready(function () {
    initialize();
    loadGrid();
    bindEvent();
});
function initialize(){

    UICtrl.layout("#layout", {leftWidth: 3});
}

function bindEvent(){

   //工厂
    $('#lifnrName').searchbox({
        type: "system", name: "dictionary",
        getParam: function (item) {
            return {fieldName: "WERKS"}
        },
        onChange: function (value, data) {
            if (data.WERKS == $("#werks").val()){
                Public.tip("供货工厂不能和收货工厂一致");
                $('#lifnr').val(null);
                $('#lifnrName').val(null);
                return false;
            }else {
                $('#lifnr').val(data.WERKS);
                $('#lifnrName').val(data.NAME1);
            }
        }
    });
    //采购组织
    $('#ekorgName').searchbox({
        type: "system", name: "dictionary",
        getParam: function (item) {
            return {fieldName: "EKORG"}
        },
        onChange: function (value, data) {
            $('#ekorg').val(data.EKORG);
            $('#ekorgName').val(data.EKOTX);
        }
    });
    //采购组
    $('#ekgrpName').searchbox({
        type: "system", name: "dictionary",
        getParam: function (item) {
            return {fieldName: "EKGRP"}
        },
        onChange: function (value, data) {
            $('#ekgrp').val(data.EKGRP);
            $('#ekgrpName').val(data.EKNAM);
        }
    });
    //公司代码
    $('#burksName').searchbox({
        type: "system", name: "dictionary",
        getParam: function (item) {
            return {fieldName: "BUKRS"}
        },
        onChange: function (value, data) {
            $('#burks').val(data.BURKS);
            $('#burksName').val(data.BUTXT);
        }
    });
    $('#werksName').searchbox({
        type: "system", name: "dictionary",
        getParam: function (item) {
            return {fieldName: "WERKS"}
        },
        onChange: function (value, data) {
            if (data.WERKS == $("#lifnr").val()){
                Public.tip("收货工厂不能和供货工厂一致");
                $('#werks').val(null);
                $('#werksName').val(null);
                return false;
            }else {
                $('#werks').val(data.WERKS);
                $('#werksName').val(data.NAME1);
            }
        }
    });
}

function loadGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
        addHandler: function () {
            UICtrl.addGridRow(gridManager,
                {
                    // 行号加一
                    ebelp: (gridManager.getData().length + 1)*10,reprf:"X"
                }
            );
        },
        deleteHandler: function () {
            var _grid = UICtrl.getGridManager('#maingrid');
            DataUtil.delSelectedRows({
                action: 'sapStockTransfersItem/deleteSapStockTransfersItems.ajax',
                param: {},
                gridManager: _grid,
                idFieldName: 'id',
                onSuccess: function () {
                    reloadGrid();
                }
            });
        }
      // copyHandler: copyHandler
       // impExcelDataHandler:{id:'impExcelData',img:'fa-table',text:'导入数据',click:impExcelDataHandler},

    });
    gridManager = UICtrl.grid("#maingrid", {
        columns: [
            {
                display: "行号", name: "ebelp", width: 80, minWidth: 60, type: "String", align: "left"
            },
            {display: "物料", name: "matnr", width: "160", align: "left", type: "string",
                editor: {
                    required: true, type: "select",
                    data: {
                        type: 'system',
                        name: "sapMaterialSelect2",
                        getParam: function (item) {
                            return {
                                filterValue:$("#lifnr").val(),
                                filterValue2:$("#werks").val()
                            }
                        },
                        back: {
                            MATNR: "matnr",
                            MAKTX: "matnrName",
                            MEINS: "meins",
                            MSEHL: "meinsName"
                        }
                    },
                }
            },
            {display: "物料名称", name: "matnrName", width: "200", align: "left", type: "string"},
            {display: "数量", name: "menge", width: 100, minWidth: 60, type: "string", align: "left",
                editor: {  type: "text",mask: 'nnnnnn.nnnn',required: true }
            },
            { display: "单位", name: "meinsName", width: 120, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: true, type: "select",
                    data: {
                        type: 'system',
                        name: "dictionary",
                        getParam: function (item) {
                            return {fieldName: "MEINS"}
                        },
                        back: {
                            MSEH3: "meins",
                            MSEHL: "meinsName"
                        }
                    },
                }
            },

            {display: "日期", name: "eeind", width: "100", align: "left", type: "string",
                editor: {required: true, type: "date"}
            },
            {display: "库存地点", name: "lgort", width: "100", align: "left", type: "string",
                editor: {
                    required: true, type: "select",
                    data: {
                        type: 'system',
                        name: "dictionary",
                        getParam: function (item) {
                            return {fieldName: "LGORT"}
                        },
                        back: {
                            LGORT: "lgort",
                            LGOBE: "lgortName"
                        }
                    },
                }
            },
            {display: "库存地点名称", name: "lgortName", width: "200", align: "left", type: "string"},
            {
                display: "备注", name: "remark", width: 300, minWidth: 60, type: "string", align: "left",
                editor: {   type: "text",maxLength:1000 }
            }
        ],
        dataAction: "server",
        url: web_app.name + '/sapStockTransfersItem/querySapStockTransfersItems.ajax',
        pageSize: 10,
        usePager: true,
        parms:{transfersId:getId()},
        toolbar: toolbarOptions,
        enabledEdit: true,
        width: "100%",
        height: "80%",
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true,
    });
    UICtrl.setSearchAreaToggle(gridManager);
}

/**
 * 流程引擎回调设置打样的id
 * @param value 打样申请的id
 */
function setId(id) {
    $("#id").val(id);

    var _grid=UICtrl.getGridManager('#maingrid');
    _grid.options.parms.transfersId = id;

}

/**
 * 流程引擎获取打样申请id的回掉方法。
 * @return 打样申请的id
 */
function getId() {
    return $("#id").val() || "";
}

function reloadGrid() {
    gridManager.loadData();
}


function getExtendedData(processAction) {
//回退、打回、转交时，不需要验证必填项是否已经填写；
    if (processAction == ProcessAction.BACK
        || processAction == ProcessAction.REPLENISH
        || processAction == ProcessAction.TRANSMIT) {
//不验证
        $('#submitForm').attr('check', false);
    }
    var extendedData = {};
    var _grid = UICtrl.getGridManager('#maingrid');
    if (_grid) {
        var datas = DataUtil.getGridData({
            gridManager: _grid,
            isAllData: true
        });

        if (!datas) {
            return false;
        }
        extendedData.items = Public.encodeJSONURI(datas);
    }
    return extendedData;
}

