var purchaseApprovalGridManager = null;
$(document).ready(function () {
        initUI();
        initPurchaseListGrid();
    }
);

function initUI() {
    UICtrl.initDefaultLayout();
}

function initPurchaseListGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
        revokeApproveHandler: {
            id: 'revokeApproveHandler', text: '撤销审批', img: 'fa-trash', click: function () {
                var row = purchaseApprovalGridManager.getSelectedRow();
                if (row.status != 3) {
                    Public.tip("请选择一条已完成的数据！");
                    return;
                }
                var loginId = $("#loginId").val();
                if (row.personMemberId != loginId) {
                    Public.tip("只能由创建人撤审！");
                    return;
                }
                UICtrl.showAjaxDialog({
                    url: web_app.name + '/sapPurchaseApproval/showRevokeDetail.load',
                    param:{id:row.id},
                    title: "撤审",
                    width: 400,
                    ok: function () {
                        var _self = this;
                        Public.ajax(web_app.name + '/sapPurchaseApproval/revokeApproval.ajax', {id: row.id,revokeReason: $("#revokeForm #revokeReason").val(),revokeType:$("#revokeType").val()}, function (msg) {
                            purchaseApprovalGridManager.loadData();
                        });
                        _self.close();
                    }
                });
            }
        }
    });
    purchaseApprovalGridManager = UICtrl.grid('#purchaseApprovalGrid', {
            columns: [
                {display: "状态", name: "statusTextView", width: "100", align: "left", type: "string"},
                {display: "id", name: "id", width: "140", align: "left", type: "string", hide: true},
                {display: "需求跟踪编号", name: "billCode", width: 150, minWidth: 60, type: "string", align: "center"},
                {display: "采购申请类型描述", name: "batxt", width: 150, minWidth: 60, type: "string", align: "center"},
                {display: "采购申请编号", name: "banfn", width: 150, minWidth: 60, type: "string", align: "center"},
                {display: "项目编号", name: "bnfpo", width: "80", align: "left", type: "string"},
                {display: "项目类别", name: "pstyp", width: "50", align: "left", type: "string"},
                {display: "项目类别描述", name: "ptext", width: "100", align: "left", type: "string"},
                {display: "科目分配类别", name: "knttp", width: "100", align: "left", type: "string"},
                {display: "科目分配类别描述", name: "knttx", width: "100", align: "left", type: "string"},
                {display: "发货工厂", name: "reswk", width: "100", align: "left", type: "string",},
                {display: "收货工厂", name: "werks", width: "100", align: "left", type: "string",},
                {display: "工厂名称", name: "name1", width: "200", align: "left", type: "string"},
                {display: "物料编号", name: "matnr", width: "200", align: "left", type: "string",},
                {display: "物料描述", name: "txz01", width: "300", align: "left", type: "string",},
                {display: "物料组", name: "matkl", width: "100", align: "left", type: "string",},
                {display: "物料组描述", name: "wgbez", width: "100", align: "left", type: "string",},
                {display: "采购申请数量", name: "menge", width: 150, minWidth: 60, type: "string", align: "center",},
                {display: "采购申请计量单位", name: "meins", width: 150, minWidth: 60, type: "string", align: "center",},
                {display: "单位描述", name: "msehl", width: 150, minWidth: 60, type: "string", align: "center",},
                {display: "要求交货日期", name: "lfdat", width: "100", align: "left", type: "string",},
                {display: "库存地点", name: "lgort", width: "100", align: "left", type: "string",},
                {display: "库存地点名称", name: "lgobe", width: "100", align: "left", type: "string"},
                {display: "采购组", name: "ekgrp", width: 150, minWidth: 60, type: "string", align: "center",},
                {display: "采购组描述", name: "eknam", width: 200, minWidth: 60, type: "string", align: "center",},
                {display: "评估价格", name: "preis", width: "100", align: "left", type: "string",},
                {display: "价格单位", name: "meins", width: 150, minWidth: 60, type: "string", align: "center",},
                {display: "币种", name: "waers", width: "100", align: "left", type: "string",},
                {display: "价格基数", name: "peinh", width: "100", align: "left", type: "string",},
                {display: "需求(请求)日期", name: "badat", width: "100", align: "left", type: "string",},
                {display: "创建人", name: "ernam", width: "100", align: "left", type: "string",},
                {display: "申请人", name: "nameText", width: "100", align: "left", type: "string",},
                {display: "消息类型", name: "type", width: 100, minWidth: 60, type: "string", align: "center"},
                {display: "消息文本", name: "message", width: 200, minWidth: 60, type: "string", align: "center"},
                {display: "创建日期", name: "fillinDate", width: 140, minWidth: 60, type: "date", align: "center"},
                {display: "撤审类型", name: "revokeTypeTextView", width: 100, minWidth: 60, type: "date", align: "center"},
                {display: "撤审原因", name: "revokeReason", width: 300, minWidth: 60, type: "date", align: "center"}
            ],
            dataAction: 'server',
            url: web_app.name + '/sapPurchaseApproval/slicedSapPurchaseApprovalList.ajax?',
            //parms: {requireItemId: $("#prepareItemId").val()},
            toolbar: toolbarOptions,
            width: '99.8%',
            height: '100%',
            pageSize: 20,
            heightDiff: -4,
            sortName: 'fillinDate',
            sortOrder: 'desc',
            checkbox: true,
            usePager: true,
            rownumbers: true,
            enabledEdit: false,
            fixedCellHeight: true,
            selectRowButtonOnly: true,
            enableObjectBag: true,
            onSuccess: function (data) {
                if (data.error) {
                    Public.tip(data.error);
                }
            }
            ,
            onDblClickRow: function (data, rowindex, rowobj) {
                viewHandler(data.id);
            },
            onAfterShowData: function (currentData) {

            }
        }
    );
    UICtrl.setSearchAreaToggle(purchaseApprovalGridManager);
}


/**
 * 查看采购申请详情
 * @param id 采购申请id
 * @returns {boolean}
 */
function viewHandler(id) {
    if (!id) {
        var row = DataUtil.getSelectedRow(purchaseApprovalGridManager);
        if (!row) {
            return row;
        }
        id = row.id;
    }
    UICtrl.addTabItem({
        tabid: 'viewPurchase' + id,
        text: '查看采购申请',
        url: web_app.name + '/sapPurchaseApproval/showSapPurchaseApprovalDetail.job?isReadOnly=true&bizId=' + id
    });
}

function addHandler() {
    UICtrl.addTabItem({
        tabid: 'addPurchase',
        text: '新增采购审批',
        url: web_app.name + '/sapPurchaseApproval/forwardSapPurchaseApprovalDetail.job'
    });
}


function reloadPurchaseGrid() {
    var params = $("#queryMainForm").formToJSON();
    UICtrl.gridSearch(purchaseApprovalGridManager, params);
}

function query(obj) {
    var param = $(obj).formToJSON();
    UICtrl.gridSearch(purchaseApprovalGridManager, param);
}

function resetForm(obj) {
    $(obj).formClean();
}

