var purchaseGridManager = null, refreshFlag = false, _roleId = null, purchaseSelectedList = [];
$(document).ready(function () {
        initUI();
        initPurchaseListGrid();

    }
);

function initUI() {
    UICtrl.initDefaultLayout();
}

function initPurchaseListGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
        addHandler: addHandler,
        revokeApproveHandler: {
            id: 'revokeApproveHandler', text: '撤销审批', img: 'fa-trash', click: function () {

                var row = purchaseGridManager.getSelectedRow();
                if (row.status!=3){
                    Public.tip("请选择一条已完成的数据！");
                    return;
                 }
                var loginId = $("#loginId").val();
                if (row.personMemberId != loginId) {
                    Public.tip("只能由创建人撤审！");
                    return;
                }
                UICtrl.showAjaxDialog({
                    url: web_app.name + '/sapPurchase/showRevokeDetail.load',
                    param:{id:row.id},
                    title: "撤审",
                    width: 400,
                    ok: function () {
                        var _self = this;
                        Public.ajax(web_app.name + '/sapPurchase/revokeApproval.ajax', {id: row.id,revokeReason: $("#revokeForm #revokeReason").val(),revokeType:$("#revokeType").val()}, function (msg) {
                            purchaseGridManager.loadData();
                        });
                        _self.close();
                    }
                });
                // UICtrl.confirm('确定要把当前单据撤销审批吗?',function(){
                //  Public.ajax(web_app.name+'/sapPurchase/revokeApproval.ajax', {id:rows[0].id}, function(msg) {
                //            purchaseGridManager.loadData();
                //  });
                // });
                   // var newRow = JSON.parse(JSON.stringify(row));
                   // newRow.zepItemno = getZepItemNo();
                   /// newRow.id = null;
                  //  UICtrl.addGridRow(item.gridManager, newRow);

            }
        }
    });

    purchaseGridManager = UICtrl.grid('#purchaseGrid', {
            columns: [
                {display: "状态", name: "statusTextView", width: "100", align: "left", type: "string"},
                {display: "id", name: "id", width: "140", align: "left", type: "string", hide: true},
                {display: "需求跟踪编号", name: "billCode", width: 150, minWidth: 60, type: "string", align: "center"},
                {display: "PR类型", name: "bsartTextView", width: 150, minWidth: 60, type: "string", align: "center"},
                {display: "科目分配类别", name: "knttpTextView", width: 150, minWidth: 60, type: "string", align: "center"},
                {display: "采购申请编号", name: "banfn", width: 150, minWidth: 60, type: "string", align: "center"},
                {display: "sap回执", name: "message", width: 200, minWidth: 60, type: "string", align: "center"},
                //{display: "批准时间", name: "frgdt", width: 200, minWidth: 60, type: "date", align: "center"},
                //{display: "申请日期", name: "fillinDate", width: 120, minWidth: 60, type: "string", align: "left"},
                {display: "录入人", name: "personMemberName", width: 120, minWidth: 60, type: "string", align: "left"},
                {display: "申购项次号", name: "bnfpo", width: "80", align: "left", type: "string",},
                {display: "工厂", name: "werks", width: "100", align: "left", type: "string"},
                {display: "工厂名称", name: "name1", width: "200", align: "left", type: "string",},
                {display: "库存地点", name: "lgort", width: "100", align: "left", type: "string"},
                {display: "库存地点名称", name: "lgobe", width: "200", align: "left", type: "string"},
                {display: "短文本", name: "txz01", width: "200", align: "left", type: "string",},
                {display: "物料组编码", name: "matkl", width: "100", align: "left", type: "string",},
                {display: "物料组", name: "matklName", width: "100", align: "left", type: "string",},
                {display: "申购数量", name: "menge", width: 150, minWidth: 60, type: "string", align: "center",},
                {display: "申购数量单位", name: "meinsName", width: 150, minWidth: 60, type: "string", align: "center",},
                {display: "采购组", name: "ekgrpName", width: 150, minWidth: 60, type: "string", align: "center",},
                {display: "批准日期", name: "frgdt", width: "100", align: "left", type: "string",},
                {display: "要求交货日期", name: "lfdat", width: "100", align: "left", type: "string",},
                {display: "申购部门", name: "afnamDeptName", width: "90", align: "left", type: "string",},
                {display: "申请人", name: "afnam", width: "90", align: "left", type: "string",},
                {display: "预估单价", name: "preis", width: "100", align: "left", type: "string",},
                {display: "价格基数", name: "ebanPeinh", width: "100", align: "left", type: "string",},
                {display: "币种", name: "waersName", width: "100", align: "left", type: "string",},
                {display: "评估金额", name: "ebanNetwr", width: "100", align: "left", type: "string",},
                {display: "成本中心", name: "kostlName", width: "200", align: "left", type: "string",},
                {display: "订单号", name: "aufnr", width: "200", align: "left", type: "string",},
                {display: "申请日期", name: "badat", width: "100", align: "left", type: "string",},
                {display: "创建日期", name: "erdat", width: "100", align: "left", type: "string",},
                {display: "打样单号", name: "prototypeCode", width: "100", align: "left", type: "string",},
                {display: "撤审类型", name: "revokeTypeTextView", width: 100, minWidth: 60, type: "date", align: "center"},
                {display: "撤审原因", name: "revokeReason", width: 300, minWidth: 60, type: "date", align: "center"}
            ],
            dataAction: 'server',
            url: web_app.name + '/sapPurchase/slicedSapPurchaseList.ajax?',
            //parms: {requireItemId: $("#prepareItemId").val()},
            toolbar: toolbarOptions,
            width: '99.8%',
            height: '100%',
            pageSize: 20,
            heightDiff: -4,
            sortName: 'fillinDate',
            sortOrder: 'desc',
            checkbox: true,
            usePager: true,
            rownumbers: true,
            enabledEdit: false,
            fixedCellHeight: true,
            selectRowButtonOnly: true,
            enableObjectBag: true,
            onSuccess: function (data) {
                if (data.error) {
                    Public.tip(data.error);
                }
            }
            ,
            onDblClickRow: function (data, rowindex, rowobj) {
                viewHandler(data.id);
            },
            onAfterShowData: function (currentData) {

            }
        }
    );
    UICtrl.setSearchAreaToggle(purchaseGridManager);
}


/**
 * 查看采购申请详情
 * @param parentId 采购申请id
 * @returns {boolean}
 */
function viewHandler(id) {
    if (!id) {
        var row = DataUtil.getSelectedRow(purchaseGridManager);
        if (!row) {
            return row;
        }
        id = row.id;
    }
    UICtrl.addTabItem({
        tabid: 'viewPurchase' + id,
        text: '查看采购申请',
        url: web_app.name + '/sapPurchase/showSapPurchaseDetail.job?isReadOnly=true&bizId=' + id
    });
}

//添加按钮
function addHandler() {
    UICtrl.showAjaxDialog({
        title: '新增',
        width: 400,
        url: web_app.name + '/sapPurchase/choosePurchaseDetail.load',
        ok: insertHandler
    });
}

function insertHandler() {
    var _self = this;
    var bsart = $("#bsart").val();
    UICtrl.addTabItem({
        tabid: 'addPurchase'+bsart,
        text: '新增采购申请',
        url: web_app.name + '/sapPurchase/forwardSapPurchaseDetail.job?bsart='+bsart
    });
    _self.close();
}

function deleteHandler() {
    var rows = DataUtil.getObjectBagData("purchaseGrid");
    if (!rows || rows.length < 1) {
        Public.tip('common.warning.nochoose');
        return;
    }
    var ids = [];
    for (var i = 0; i < rows.length; i++) {
        var row = rows[i];
        if (row.status != 0) {
            Public.errorTip('只能删除草稿状态的数据!');
            return;
        }
        ids.push(row.id);
    }
    if (!ids) {
        return;
    }
    Public.ajax(web_app.name + '/purchaseItem/deleteByIds.ajax',
        {ids: $.toJSON(ids)},
        function () {
            reloadPurchaseGrid();
        });
}

function reloadPurchaseGrid() {
    var params = $("#queryMainForm").formToJSON();
    UICtrl.gridSearch(purchaseGridManager, params);
}

function query(obj) {
    var param = $(obj).formToJSON();
    UICtrl.gridSearch(purchaseGridManager, param);
}

function resetForm(obj) {
    $(obj).formClean();
}

