var gridManager = null;
var sapFinaCustomerPayGridManager = null;
var sapFinaCustomerBankGridManager = null;
var  canEdit=true;

$(document).ready(function () {
    initialize();
    loadFinaCustomerPayListGrid();
    loadFinaCustomerBankListGrid();
    bindEvent();
});
function initialize(){
    UICtrl.layout("#layout", {leftWidth: 3});
    if (applyType=="-1"){
      //  $("form[id='submitForm']:text").attr("disabled","disabled");
      //  disableForm("submitForm","disabled");
        UICtrl.setDisable($("#submitForm"));
        canEdit=false;
    }
    if (applyType=="1"){
        UICtrl.disable("#zbz01");
    }
    $('#supplierList').fileList({
        bizId : $("#id").val()
    });

 }

/**
 * 流程引擎回调设置打样的id
 * @param value 打样申请的id
 */
function setId(bizId) {
    $("#id").val(bizId);
    var _grid = UICtrl.getGridManager('#sapFinaCustomerPayGrid');
    _grid.options.parms.sId = bizId;
    var _grid3 = UICtrl.getGridManager('#sapFinaCustomerBankGrid');
    _grid3.options.parms.sId = bizId;
    $("#sId").val(bizId);
    sapFinaCustomerPayGridManager.loadData();
    sapFinaCustomerBankGridManager.loadData();

    $('#supplierList').fileList({
        bizId : bizId
    });
}

/**
 * 流程引擎获取打样申请id的回掉方法。
 * @return 打样申请的id
 */
function getId() {
    var id=$("#id").val() || "";
    return id;
}

function getsId() {
    var sid=$("#id").val() || "";  //alert(applyType); alert($("#sId").val());
    if (applyType!="0"){ // alert("sID=00===="+$("#sId").val())
        sid=$("#sId").val();
    }
    return sid;

}

// 加载付款信息表格
function loadFinaCustomerPayListGrid() {
    var toolbarOptions = null;
    if (applyType == 0){
        toolbarOptions = UICtrl.getDefaultToolbarOptions({
            // 添加一行表格
            addHandler: function () {
                UICtrl.addGridRow(sapFinaCustomerPayGridManager,
                    {
                        // 行号加一
                        sequence: (sapFinaCustomerPayGridManager.getData().length + 1)*10,
                        //( "0000000000000000" + num ).substr( -length )
                        zuawa:  "001",
                        zuawaName:  "过账日期",
                    }
                );
            },
            // 删除选中的尺码信息
            deleteHandler: function () {
                var _grid = UICtrl.getGridManager('#sapFinaCustomerPayGrid');
                DataUtil.delSelectedRows({
                    action: 'finaCustomer/deleteFinaCustomerPays.ajax',
                    param: {},
                    gridManager: _grid,
                    idFieldName: 'id',
                    onSuccess: function () {
                        sapFinaCustomerPayGridManager.loadData();
                    }
                });
            }
        });
    }
    // 表格
    sapFinaCustomerPayGridManager = UICtrl.grid("#sapFinaCustomerPayGrid", {
        //gridManager: null,
        columns: [
            {
                display: "行号", name: "sequence", width: 80, minWidth: 60, type: "String", align: "left",
                //editor: {type: 'spinner', min: 1, max: 100, mask: 'nnn'}
            },
            {
                display: "公司代码", name: "bukrs", width: 100, minWidth: 60, type: "String", align: "left",
                editor: {
                    required: true, type: "select",
                    data: {
                        type: 'system',
                        name: "dictionary",
                        getParam: function (item) {
                            return {fieldName: "BUKRS"}
                        },
                        back: {
                            BUKRS: "bukrs",
                        }
                    },
                }
            },
            {
                display: "统驭科目", name: "akontCustomerTextView", width: 140, minWidth: 60, type: "String", align: "left",
                editor: {
                    type: 'dictionary',
                    data: {name: 'akontCustomer'},
                    textField: 'akontCustomerTextView',
                    valueField: 'akontCustomer',
                    required: true,
                    render: function (item) {
                        return item.akontCustomerTextView;
                    }
                },
            },
            {
                display: "根据分配号排序代码", name: "zuawaName", width: 150, minWidth: 60, type: "String", align: "left",
                // editor: {
                //     required: true, type: "select",
                //     data: {
                //         type: 'system',
                //         name: "dictionary",
                //         getParam: function (item) {
                //             return {fieldName: "ZUAWA"}
                //         },
                //         back: {
                //             ZUAWA: "zuawa",
                //             TTEXT: "zuawaName"
                //         },
                //
                //     },
                // }
            },
            {
                display: "付款条件", name: "zterm", width: 100, minWidth: 60, type: "String", align: "left",
                editor: {
                    required: false, type: "select",
                    data: {
                        type: 'system',
                        name: "dictionary",
                        getParam: function (item) {
                            return {fieldName: "ZTERM"}
                        },
                        back: {
                            ZTERM: "zterm",
                            TEXT1: "ztermName",
                        }
                    },
                }
            },
            {
                display: "付款条件描述", name: "ztermName", width: 100, minWidth: 60, type: "String", align: "left"
            },
            {
                display: "考虑的付款方式清单", name: "zwelsTextView", width: 140, minWidth: 60, type: "String", align: "left",
                editor: {
                    type: 'dictionary',
                    data: {name: 'zwels'},
                    textField: 'zwelsTextView',
                    valueField: 'zwels',
                    //  checkbox:true,
                    required: false,
                    render: function (item) {
                        return item.zwelsTextView;
                    }
                },
            },
            {
                display: "对公司代码过帐冻结", name: "sperrBTextView", width: 140, minWidth: 60, type: "String", align: "left",
                editor: {
                    type: 'dictionary',
                    data: {name: 'sperrB'},
                    textField: 'sperrBTextView',
                    valueField: 'sperrB',
                    required: false,
                    render: function (item) {
                        return item.sperrBTextView;
                    }
                }
            },
        ],
        dataAction: "server",
        _tableKey: 'finaCustomerPay',
        _local: true,
        url: web_app.name + '/finaCustomer/slicedFinaCustomerPayData.ajax',
        parms: {sId: getsId},
        pageSize: 20,
        usePager: true,
        toolbar: toolbarOptions,
        enabledEdit: canEdit,
        width: "98%",
        height: "300px",
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true,
    });
    UICtrl.setSearchAreaToggle(sapFinaCustomerPayGridManager);
}

// 加载银行信息表格
function loadFinaCustomerBankListGrid() {
    var toolbarOptions = null;
    if (applyType == 0){
        toolbarOptions = UICtrl.getDefaultToolbarOptions({
            // 添加一行表格
            addHandler: function () {
                UICtrl.addGridRow(sapFinaCustomerBankGridManager,
                    {
                        // 行号加一
                        sequence: (sapFinaCustomerBankGridManager.getData().length + 1)*10
                    }
                );
            },
            // 删除选中的尺码信息
            deleteHandler: function () {
                var _grid = UICtrl.getGridManager('#sapFinaCustomerBankGrid');
                DataUtil.delSelectedRows({
                    action: 'finaCustomer/deleteFinaCustomerBanks.ajax',
                    param: {},
                    gridManager: _grid,
                    idFieldName: 'id',
                    onSuccess: function () {
                        sapFinaCustomerBankGridManager.loadData();
                    }
                });
            }
        });
    }
    // 表格
    sapFinaCustomerBankGridManager = UICtrl.grid("#sapFinaCustomerBankGrid", {
        gridManager: null,
        columns: [
            {
                display: "行号", name: "sequence", width: 80, minWidth: 60, type: "String", align: "left",
                //editor: {type: 'spinner', min: 1, max: 100, mask: 'nnn'}
            },
            {
                display: "银行所属国家", name: "banksTextView", width: 150, minWidth: 60, type: "String", align: "left",
                editor: {
                    required: true, type: "select",
                    data: {
                        type: 'system',
                        name: "dictionarySelect",
                        getParam: function (item) {
                            return {fieldName: "country",displayNames:"国家",displayLens:"180"}
                        },
                       // checkbox:true,
                       // checkboxIndex:'value',
                        back: {
                            value: "banks",
                            name:"banksTextView"
                        }
                       // valueIndex:'value'
                    },
                }
            },
            {
                display: "银行代码", name: "bankl", width: 200, minWidth: 60, type: "String", align: "left",
                editor: {
                    required: true, type: "select",
                    data: {
                        type: 'system',
                        name: "getBankInfo",
                        getParam: function (item) {
                            return {BANKS: item.banks}
                        },
                        back: {
                            BANKL: "bankl",
                            BANKA: "banka",
                        }
                    },
                }
            },
            {
                display: "银行名称", name: "banka", width: 300, minWidth: 60, type: "String", align: "left",
                //editor: {type: 'text', required: false}
            },
             {
                 display: "银行帐户号码", name: "bankn", width: 200, minWidth: 60, type: "String", align: "left",
                 editor: {type: 'text', required: true, maxLength :18 }
             },
            {
                display: "银行细目的参考明细", name: "bkref", width: 140, minWidth: 60, type: "String", align: "left",
                editor: {type: 'text', required: false}
            },
             {
                 display: "账户持有人姓名", name: "koinh", width: 120, minWidth: 60, type: "String", align: "left",
                 editor: {type: 'text', required: false}
             },
             {
                 display: "账户名称", name: "accname", width: 140, minWidth: 60, type: "String", align: "left",
                 editor: {type: 'text', required: false}
             },
        ],
        dataAction: "server",
        _tableKey: 'finaCustomerBank',
        _local: true,
        url: web_app.name + '/finaCustomer/slicedFinaCustomerBankData.ajax',
        parms: {sId: getsId},
        pageSize: 20,
        usePager: true,
        toolbar: toolbarOptions,
        enabledEdit: canEdit,
        width: "98%",
        height: "300px",
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true,
    });
    UICtrl.setSearchAreaToggle(sapFinaCustomerBankGridManager);
}

//获取数据保存的参数
function getExtendedData(processAction) {
    //回退、打回、转交时，不需要验证必填项是否已经填写；
    if (processAction == ProcessAction.BACK
        || processAction == ProcessAction.REPLENISH
        || processAction == ProcessAction.TRANSMIT) {
        //不验证
        $('#submitForm').attr('check', false);
    }
    var stenr = $("#stenr").val();
    var taxTypeName = $("#taxTypeName").val();
    if (Public.isNotBlank(stenr) && Public.isBlank(taxTypeName)){
        Public.tip("税号必须要有对应的税号类型");
        return false;
    }
    const isAllData = $('#oldId') || !getId();
    var extendedData = {};
    var _grid = UICtrl.getGridManager('#sapFinaCustomerPayGrid');
    if (_grid) {
        var datas = DataUtil.getGridData({
            gridManager: _grid,
            isAllData: isAllData
        });
        if (!datas) {
            return false;
        }
        extendedData.finaCustomerPayList = Public.encodeJSONURI(datas);
    }

    var bank_grid = UICtrl.getGridManager('#sapFinaCustomerBankGrid');
    if (bank_grid) {
        var datas = DataUtil.getGridData({
            gridManager: bank_grid,
            isAllData: isAllData
        });
        if (!datas) {
            return false;
        }
        extendedData.finaCustomerBankList = Public.encodeJSONURI(datas);
    }
    return extendedData;
}


function checkConstraints(){
    //银行信息
    var bank_grid = UICtrl.getGridManager('#sapFinaCustomerBankGrid');
    if (bank_grid) {
        var datas = DataUtil.getGridData({
            gridManager: bank_grid,
            isAllData: true
        });
        if (!datas) {
            return false;
        }
        if (isApplyProcUnit() && datas.length == 0 ){
            Public.tip("财务客户银行信息必填");
            return false;
        }
    }
    //付款信息
    var pay_grid = UICtrl.getGridManager('#sapFinaCustomerPayGrid');
    if (pay_grid) {
        var datas = DataUtil.getGridData({
            gridManager: pay_grid,
            isAllData: true
        });
        if (!datas) {
            return false;
        }
        if (isApplyProcUnit() && datas.length == 0){
            Public.tip("财务客户公司信息必填");
            return false;
        }
    }
    return true;
}


function bindEvent(){
    $('#countryName').searchbox({
        type: "system", name: "dictionary",
        getParam: function (item) {
            return {
                fieldName: "LAND1",
            }
        },
        onChange: function (value, data) {
            $('#country').val(data.LAND1);
            $('#countryName').val(data.LANDX);
        }
    });

    $('#regionName').searchbox({
        type: "system", name: "getArea",
        getParam: function (item) {
            if (Public.isBlank($('#country').val())){
                Public.tip("请先选择国家")
                return false;
            }
            return {
                LAND1: $('#country').val(),
            }
        },
        onChange: function (value, data) {
            $('#region').val(data.BLAND);
            $('#regionName').val(data.BEZEI);
        }
    });

    $('#taxTypeName').searchbox({
        type: "system", name: "dictionary",
        getParam: function (item) {
            return {
                fieldName: "TTYPE",
            }
        },
        onChange: function (value, data) {
            $("#taxType").val(data.TAXTYPE);
            $("#taxTypeName").val(data.TEXT);
        }
    });

    $('input[name="stenr"]').mouseout(function () {
        let val = $(this).val()
        if (Public.isNotBlank(val)){
            UICtrl.setElHideOrShow("#taxTypeName",false)
            UICtrl.setElRequiredFlag("#taxTypeName",true)
            $("#taxTypeName").val("中国：税号");
            $("#taxType").val("CN5");
        }else {
            UICtrl.setElHideOrShow("#taxTypeName",true)
            UICtrl.setElRequiredFlag("#taxTypeName",false)
            $("#taxTypeName").val("");
            $("#taxType").val("");
        }
    })

}

function reloadGrid() {
    sid=$("#id").val();
    sapFinaCustomerPayGridManager.loadData();
    sapFinaCustomerBankGridManager.loadData();
}