var gridManager = null, refreshFlag = false;
$(document).ready(function () {
        initUI();
        initGrid();
    }
);

function initUI() {
    UICtrl.initDefaultLayout();
}

function initGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({

    });
    gridManager = UICtrl.grid('#belnrgrid', {
            columns: [
                {
                    display: "采购订单号", name: "EBELN", width: 120, minwidth: 120, type: "string", align: "left",
                },
                {
                    display: "采购订单行", name: "EBELP", width: 120, minwidth: 120, type: "string", align: "left",
                },
                {
                    display: "币别", name: "WAERS", width: 120, minwidth: 120, type: "string", align: "left",
                },
                {
                    display: "汇率", name: "KURSF", width: 120, minwidth: 120, type: "string", align: "left",
                },
                {
                    display: "不含税金额（本位币）", name: "NETWR1", width: 120, minwidth: 120, type: "money", align: "left",
                },
                {
                    display: "税额（本位币）", name: "KWETR1", width: 120, minwidth: 120, type: "money", align: "left",
                },
                {
                    display: "含税金额（本位币）", name: "KZWI11", width: 120, minwidth: 120, type: "money", align: "left",
                },
                {
                    display: "税码", name: "MWSKZ", width: 100, minwidth: 120, type: "string", align: "left",
                },
                {
                    display: "不含税金额", name: "NETWR", width: 120, minwidth: 120, type: "money", align: "left",
                },
                {
                    display: "税额", name: "KWETR", width: 100, minwidth: 120, type: "string", align: "left",
                },
                {
                    display: "含税金额", name: "KZWI1", width: 120, minwidth: 120, type: "money", align: "left",
                },

            ],
            dataAction: 'server',
            url: web_app.name + '/sapCostReimbursement/getPurchaseOrders.ajax?',
            parms: {
                zepFtype:"D",
                bukrs:$("#bukrs").val(),
                partner:$("#partner").val()
            },
            toolbar: toolbarOptions,
            width: '99.8%',
            height: 400,
            pageSize: 20,
            heightDiff: -4,
            sortName: 'num',
            sortOrder: 'asc',
            checkbox: true,
            usePager: false,
            rownumbers: true,
            enabledEdit: true,
            fixedCellHeight: true,
            selectRowButtonOnly: true,
            enableObjectBag: true,
        }
    );
    UICtrl.setSearchAreaToggle(gridManager);
}

function reloadDetailGrid() {
    gridManager.loadData();
}

function query(obj) {
    var param = $(obj).formToJSON();
    UICtrl.gridSearch(gridManager, param);
}

function resetForm(obj) {
    $(obj).formClean();
    reloadDetailGrid();
}

