var gridManager = null;

$(document).ready(function () {
    loadAcceptanceFormAckGrid();
    searchAreaToggle();
});

// function initializateUI() {
//     UICtrl.layout("#layout", {leftWidth: 3});
// }

function loadAcceptanceFormAckGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
        updateHandler: function () {
        },
        markHandler: {
            id: 'markHandler', text: '验收标记', img: 'fa-clipboard', click: function () {
                markHandler("X");
            }
        },
        cancelMarkHandler: {
            id: 'cancelMarkHandler', text: '取消验收标记', img: 'fa-clipboard', click: function () {
                markHandler("");
            }
        }
    });
    gridManager = UICtrl.grid("#acceptanceFormAckGrid", {
        columns: [
            {display: "验收单业务标记", name: "zacfmk", width: 120, minWidth: 60,  type: "string",  align: "center",
                render: function(item) {
                    if(item.zacfmk === "X") {
                        return "<a href='#'  class='GridStyle'>取消</a>";
                    }
                    return "<a href='#'  class='GridStyle'>标记</a>";
                }},
            {display: "销售凭证", name: "vgbel", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "销售凭证项目", name: "vgpos", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "物料编号", name: "matnr", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "物料描述", name: "maktx", width: 100, minWidth: 60, type: "string", align: "left"},
            {display: "销售和分销凭证号", name: "vbeln", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "销售和分销凭证的项目号", name: "posnr", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "销售组织", name: "vkorg", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "售达方", name: "kunag", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "名称", name: "name1", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "请款联", name: "katr6", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "交货日期", name: "lfdat", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "客户编号", name: "zhdlr", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "客户名称", name: "zhdnm", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "验收单标记人", name: "zmkp4", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "验收单标记时间", name: "zmkt4", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "验收单业务标记", name: "zacsmk", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "验收单业务标记人", name: "zmkp5", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "验收单业务标记时间", name: "zmkt5", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "客户物料", name: "kdmat", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "参考的描述", name: "postx", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "客户参考", name: "bstkd", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "指令号", name: "zinsn", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "型体号", name: "zmold", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "配色号", name: "zmapcolor", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "段别", name: "zsegm", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "实际已交货量（按销售单位）", name: "lfimg", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "以销售单位表示的累计订购数量", name: "kwmeng", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "请款数量", name: "zcorqt", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "销售单位", name: "vrkme", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "净价", name: "netpr", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "SD 凭证货币", name: "waerk", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "备注", name: "zcnote", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "请款单号", name: "zcrnr", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "请款单项次", name: "zcritm", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "做账人", name: "zcrrsp", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "做账时间", name: "zctime", width: 120, minWidth: 60, type: "string", align: "left"}
        ],
        dataAction: "server",
        url: web_app.name + '/sapAcceptanceForm/findAcceptanceForm.ajax',
        enabledEdit: true,
        pageSize: 20,
        usePager: true,
        toolbar: toolbarOptions,
        width: "100%",
        height: "100%",
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true,
        onDblClickRow: function (data, rowindex, rowobj) {
            // updateHandler(data);
        }
    });
    UICtrl.setSearchAreaToggle(gridManager, true);
}

function sampling (str) {
    let rowData = JSON.parse(decodeURIComponent(str));
    let loginCode = document.getElementById('loginCode').value;
    let zacsmk = !(rowData.zacsmk*1);
    let zmkt4 = new Date().getTime();
    let params = {
        "vbeln": rowData.vbeln,
        "posnr": rowData.posnr,
        "zacsmk": zacsmk,
        "zmkp4": loginCode,
        "zmkt4": zmkt4
    }

    Public.ajax(web_app.name + "/sapAcceptanceForm/ackAcceptanceForm.ajax", params,
        function (data) {
        query();
    });

}

function query() {
    let process = $('#queryMainForm').formToJSON({ check: true });
    if(!process) { return; }
    var params = $('#queryMainForm').formToJSON();
    if(!compareForDate(params.zmkt4, params.zmkt4_end)) {
        $('#zmkt4').val('').onFocus();
        $('#zmkt4_end').val('')
        return;
    }
    if(!compareForDate(params.lfdat, params.lfdat_end)) {
        $('#lfdat').val('').onFocus();
        $('#lfdat_end').val('')
        return;
    }
    params.zaicsm = params.zaicsm === undefined ? '' : !(params.zaicsm*1) ? '' : 'X';
    params.zacfmk = params.zacfmk === undefined ? '' : !(params.zacfmk*1) ? '' : 'X';
    //setCriteria(params);
    // params.singleProcInstShowOneTask = $("#singleProcInstShowOneTask").is(":checked");
    UICtrl.gridSearch(gridManager, params);
}
function setCriteria(params) {
    params.zacfmk='';
    params.vkorg='';
    params.kunag='';
    params.vbeln_low='';
    params.vbeln_high='';
    params.zsckdt_low='';
    params.zsckdt_high='';
    params.lfdat_low='';
    params.lfdat_high='';
    // params.zacfmk='X';
    // params.vkorg='1000';
    // params.kunag='0000600005';
    // params.vbeln_low='0080000002';
    // params.vbeln_high='0080000005';
    // params.zsckdt_low='20240101';
    // params.zsckdt_high='20240510';
    // params.lfdat_low='20240101';
    // params.lfdat_high='20240510';
}

/**
 * 展开搜索框
 */
function searchAreaToggle() {
    setTimeout(function() {
        $('a.togglebtn').click();
    }, 500);
}

//日期大小比较
function compareForDate(start,end){
    if(start && end) {
        start = start.replace(/-/g,'').replace(/ /g,'').replace(/:/g,'');
        end=end.replace(/-/g,'').replace(/ /g,'').replace(/:/g,'');
        start = parseInt(start,10);
        end=parseInt(end,10);
        if(isNaN(start)||isNaN(end)){
            return true;
        }
        if(start>end){
            Public.tip('开始时间不能大于结束时间!');
            return false;
        }
    }
    return true;
}

function resetForm(obj) {
    $(obj).formClean();
}

function markHandler(mark){
    const rows = gridManager.getSelectedRows();
    if (rows.length == 0) {
        Public.tip("请选择数据！");
        return;
    }
    var params =[];
    rows.forEach(rowData=>{
        let loginCode = document.getElementById('loginCode').value;
        let param = {
            "VBELN": rowData.vbeln,
            "POSNR": rowData.posnr,
            "ZACFMK": mark,
            "ZMKP4": loginCode,
            "ZMKT4": Public.formatDate(new Date(),'%Y%M%D')
        }
        params.push(param);
    })
    Public.ajax(web_app.name + "/sapAcceptanceForm/ackAcceptanceForm.ajax", {params:$.toJSON(params)},
        function (data) {
            Public.tip(data);
            query();
        });
}

