var gridManager = null;

$(document).ready(function () {
    initUI();
    loadGrid();
})
function initUI() {
    UICtrl.initDefaultLayout();
}

function loadGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
        //addHandler: addHandler,
        uploadFileHandler: {
            id: 'uploadFileHandler', text: '上传附件', img:'fa-clipboard', click: function(){
                uploadFile();
            }
        },
        printHandler: {
            id: 'print', text: '打印', img:'fa-clipboard', click: function(){
                printHandler();
            }
        },
    });
    gridManager = UICtrl.grid("#maingrid", {
        columns: [
            {display: "单据编号", name: "billCode", width: 150, minWidth: 60, type: "string", align: "left"},
            {display: "创建日期", name: "fillinDate", width: 120, minWidth: 60, type: "date", align: "left"},
            {display: "申请人", name: "personMemberName", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "申请部门", name: "deptName", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "物料凭证号", name: "mblnr", width: 200, minWidth: 60, type: "string", align: "left"},
            {display: "凭证项次", name: "zeile", width: 200, minWidth: 60, type: "string", align: "left"},
            {display: "凭证年份", name: "mjahr", width: 200, minWidth: 60, type: "string", align: "left"},
            {display: "产品名称", name: "productName", width: 200, minWidth: 60, type: "string", align: "left"},
            {display: "类别", name: "type", width: 200, minWidth: 60, type: "string", align: "left"},
            {display: "采购单号", name: "purchaseOrderNo", width: 200, minWidth: 60, type: "string", align: "left"},
            {display: "生产批次", name: "batchNo", width: 200, minWidth: 60, type: "string", align: "left"},
            {display: "PD/YL编码", name: "pd", width: 200, minWidth: 60, type: "string", align: "left"},
            {display: "部门/工序", name: "process", width: 200, minWidth: 60, type: "string", align: "left"},
            {display: "异常数量", name: "exceptionNum", width: 200, minWidth: 60, type: "string", align: "left"},
            {display: "异常描述", name: "exceptionDesc", width: 200, minWidth: 60, type: "string", align: "left"},
            {display: "评审部门", name: "dutyDeptName", width: 200, minWidth: 60, type: "string", align: "left"},
            {display: "提报人", name: "submitterName", width: 200, minWidth: 60, type: "string", align: "left"},
            {display: "评审结果", name: "resultTextView", width: 200, minWidth: 60, type: "string", align: "left"},
            {display: "审批状态", name: "statusTextView", width: 100, minWidth: 60, type: "string", align: "left"},
            {display: "状态码", name: "code", width: 100, minWidth: 60, type: "string", align: "left"},
            {display: "消息", name: "msg", width: 300, minWidth: 60, type: "string", align: "left"},
        ],
        dataAction: "server",
        url: web_app.name + '/unqualifiedMaterials/slicedUnqualifiedMaterialsList.ajax',
        pageSize: 20,
        usePager: true,
        sortName: "fillinDate",
        sortOrder: "desc",
        toolbar: toolbarOptions,
        width: "100%",
        height: "100%",
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true,
        onDblClickRow: function (data, rowindex, rowobj) {
            doView(data.id);
        },
    });
    UICtrl.setSearchAreaToggle(gridManager);
}

function query(obj) {
    var param = $(obj).formToJSON();
    UICtrl.gridSearch(gridManager, param);
}
function reloadGrid() {
    gridManager.loadData();
}

function resetForm(obj) {
    $(obj).formClean();
}

function addHandler() {
    UICtrl.addTabItem({
        tabid: 'unqualifiedMaterials',
        text: "新增质量异常评审表",
        url: web_app.name + '/unqualifiedMaterials/forwardUnqualifiedMaterialsDetail.job'
    });
}

function doView(id) {
    UICtrl.addTabItem({
        tabid: 'unqualifiedMaterials'+id,
        text: "查看质量异常评审表",
        url: web_app.name + '/unqualifiedMaterials/showUnqualifiedMaterialsDetail.job?bizId='+id+"&isReadOnly=true"
    });
}

function uploadFile(){
    var row = gridManager.getSelectedRow();
    UICtrl.showAjaxDialog({
        title: $.i18nProp('相关附件'),
        width: 600,
        url: web_app.name + '/unqualifiedMaterials/uploadFile.load?id='+row.id,
        init: function (div) {
            $('#fileList').fileList({bizId:row.id});
        },
        okVal: 'common.button.ok',
        ok: function (div) {
        }
    });
}

function printHandler(){
    var row = DataUtil.getUpdateRow(gridManager);
    if (!row) {
        return;
    }
    // if (row.status != 3){
    //     Public.tip("请审批完成再打印!");
    //     return;
    // }
    var url='/unqualifiedMaterials/print.load';
    Public.openPostWindow(web_app.name+url,{id :row.id});
}
