var gridManager = null;

$(document).ready(function () {
    initUI();
    loadGrid();
})
function initUI() {
    UICtrl.initDefaultLayout();
}

function loadGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
    });
    gridManager = UICtrl.grid("#maingrid", {
        columns: [
            {display: "单据编号", name: "billCode", width: 150, minWidth: 60, type: "string", align: "left"},
            {display: "创建日期", name: "fillinDate", width: 120, minWidth: 60, type: "date", align: "left"},
            {display: "申请人", name: "personMemberName", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "申请部门", name: "deptName", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "异常单号", name: "exceptionNo", width: 200, minWidth: 60, type: "string", align: "left"},
            {display: "编排单号", name: "layoutNo", width: 200, minWidth: 60, type: "string", align: "left"},
            {display: "工序名称", name: "process", width: 200, minWidth: 60, type: "string", align: "left"},
            {display: "工作中心名称", name: "workerCenter", width: 200, minWidth: 60, type: "string", align: "left"},
            {display: "作业单元名称", name: "workerUnit", width: 200, minWidth: 60, type: "string", align: "left"},
            {display: "物料号", name: "materialNo", width: 200, minWidth: 60, type: "string", align: "left"},
            {display: "物料名称", name: "materialName", width: 200, minWidth: 60, type: "string", align: "left"},
            {display: "异常类型", name: "exceptionType", width: 200, minWidth: 60, type: "string", align: "left"},
            {display: "异常原因", name: "exceptionReason", width: 200, minWidth: 60, type: "string", align: "left"},
            {display: "异常描述", name: "exceptionDesc", width: 200, minWidth: 60, type: "string", align: "left"},
            {display: "异常时间", name: "exceptionDate", width: 200, minWidth: 60, type: "string", align: "left"},
            {display: "提报人", name: "submitterName", width: 200, minWidth: 60, type: "string", align: "left"},
            {display: "审批人", name: "approvalName", width: 200, minWidth: 60, type: "string", align: "left"},
            {display: "处理结果", name: "result", width: 200, minWidth: 60, type: "string", align: "left"},
            {display: "审批状态", name: "statusTextView", width: 100, minWidth: 60, type: "string", align: "left"},
            {display: "状态码", name: "code", width: 100, minWidth: 60, type: "string", align: "left"},
            {display: "消息", name: "msg", width: 300, minWidth: 60, type: "string", align: "left"},
        ],
        dataAction: "server",
        url: web_app.name + '/produceException/slicedProduceExceptionList.ajax',
        pageSize: 20,
        usePager: true,
        toolbar: toolbarOptions,
        width: "100%",
        height: "100%",
        heightDiff: -8,
        sortName: 'fillinDate',
        sortOrder: 'desc',
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true,
        onDblClickRow: function (data, rowindex, rowobj) {
            doView(data.id);
        },
    });
    UICtrl.setSearchAreaToggle(gridManager);
}

function query(obj) {
    var param = $(obj).formToJSON();
    UICtrl.gridSearch(gridManager, param);
}
function reloadGrid() {
    gridManager.loadData();
}

function resetForm(obj) {
    $(obj).formClean();
}

function doView(id) {
    UICtrl.addTabItem({
        tabid: 'produceException'+id,
        text: "异常单",
        url: web_app.name + '/produceException/showProduceExceptionDetail.job?bizId='+id+"&isReadOnly=true"
    });
}
