package com.huigou.topsun.resource.service;


import com.baomidou.mybatisplus.extension.service.IService;
import com.huigou.topsun.resource.domain.ResourceType;
import com.huigou.topsun.resource.vo.ResourceFiledVo;
import com.huigou.topsun.resource.vo.ResourceTypeTreeVo;
import com.huigou.topsun.resource.vo.ResourceTypeVo;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
* @author 16508
* @description 针对表【resource_type(资源分类)】的数据库操作Service
* @createDate 2023-10-25 16:08:43
*/
public interface ResourceTypeService extends IService<ResourceType> {

    ResourceTypeVo saveResourceTypeMain(ResourceTypeVo resourceTypeVo);

    ResourceTypeVo updateResourceTypeMain(ResourceTypeVo resourceType);

    void deleteById(String id);

    ResourceTypeVo findById(String id);

    List<ResourceTypeVo> findList();

    ResourceTypeVo findByTableName(String tableName);


    List<ResourceFiledVo> findParentResourceFileds(String tableName);

    void findParentMenusRecursively(String tableName, Set<ResourceFiledVo> resourceFileds);

    ResourceTypeVo initResourceTypeVo(String tableName);

    List<ResourceFiledVo> findResourceTypeFields(String tableName);

    List<ResourceTypeTreeVo> queryResourceTypes(String parentTableName);
}
