package com.huigou.topsun.product.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.huigou.topsun.common.NumberToStringSerializer;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author YourUserName
 * 产品版面信息
 */
@JsonInclude(JsonInclude.Include.ALWAYS)
@JsonIgnoreProperties(ignoreUnknown = true)
@Entity
@Table(name = "product_face")
public class ProductFace implements Serializable {

	/**
	 * 产品版面ID
	 */
	@Id
	@JsonSerialize(using = NumberToStringSerializer.class)
	@Column(name = "product_face_id", nullable = false)
	private BigDecimal productFaceId;

	/**
	 * 产品版面图片
	 */
	@Column(name = "product_image", nullable = true, length = 512)
	private String productImage;

	@Override
	public boolean equals(Object o) {
		if (this == o) return true;
		if (o == null || getClass() != o.getClass()) return false;
		ProductFace that = (ProductFace) o;
		return new EqualsBuilder().append(productFaceId, that.productFaceId).append(productImage, that.productImage).isEquals();
	}

	@Override
	public int hashCode() {
		return new HashCodeBuilder(17, 37).append(productFaceId).append(productImage).toHashCode();
	}

	public BigDecimal getProductFaceId() {
		return this.productFaceId;
	}
	
	public void setProductFaceId (String  productFaceId) {
		this.productFaceId = (productFaceId == null) || productFaceId.isEmpty() ? null : new BigDecimal(productFaceId);
	}
	
	public String getProductImage() {
		return this.productImage;
	}
	
	public void setProductImage(String productImage) {
		this.productImage = productImage;
	}
}
