package com.huigou.topsun.syncOrg.vo;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

/**
 * @Auther: xin.lu
 * @Date: 2024/03/23/10:30
 * @Description: 同步到EP系统机构/部门/岗位Vo类
 */
@Data
public class OrgVo {
    @JsonProperty("deptId")
    private String id;

    /**
     * 父节点ID
     */
    @JsonProperty("parentId")
    private String parentId;

    /**
     * 编码全路径
     */
    @JsonProperty("deptCode")
    private String fullCode;

    /**
     * 名称
     */
    @JsonProperty("deptName")
    private String name;

    /**
     * 顺序
     */
    @JsonProperty("orderNum")
    private Integer sequence;

    /**
     * 负责人
     */
    @JsonProperty("leader")
    private String leader;

    /**
     * 邮箱
     */
    @JsonProperty("email")
    private String email;


    /**
     * 联系电话
     */
    @JsonProperty("phone")
    private String phone;

    /**
     * 状态（0代表禁用 1代表启用）
     */
    @JsonProperty("status")
    private Integer status;

    /**
     * 删除标志（0代表存在 2代表删除）
     */
    @JsonProperty("delFlag")
    private String delFlag;

    /**
     * 父部门名称
     */
    @JsonProperty("parentName")
    private String parentName;

    /**
     * 组织节点类型
     */
    @JsonProperty("orgKindId")
    private String orgKindId;
}
