package com.huigou.topsun.sap.transfers.controller;

import com.huigou.topsun.sap.transfers.application.SapStockTransfersItemApplication;
import com.huigou.topsun.sap.transfers.domain.query.SapStockTransfersQueryRequest;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import java.util.List;
import java.util.Map;

/**
 * @Auther: LXH
 * @Date:  2024/03/28 10:10
 * @Description:
 */
@Controller
@ControllerMapping("/sapStockTransfersItem")
public class SapStockTransfersItemController extends CommonController {
    @Autowired
    private SapStockTransfersItemApplication sapStockTransfersItemApplication;

    public String querySapStockTransfersItems(){
        SDO sdo = this.getSDO();
        SapStockTransfersQueryRequest queryRequest = sdo.toQueryRequest(SapStockTransfersQueryRequest.class);
        Map<String, Object> map = sapStockTransfersItemApplication.querySapStockTransfersItems(queryRequest);
        return toResult(map);
    }

    public String deleteSapStockTransfersItems(){
        SDO sdo = this.getSDO();
        List<String> ids = sdo.getIds();
        sapStockTransfersItemApplication.deleteByIds(ids);
        return success();
    }
}
