package com.huigou.topsun.sap.suppliers.domain.vo;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 供应商主数据
  */
@Data
public class SuppliersInfoVo implements Serializable {

    /**
     * 屏幕用途的bp角色
     */
    @JsonProperty("RLTGR")
    private String rltgr;

    /**
     * 业务伙伴分组
     */
    @JsonProperty("BU_GROUP")
    private String buGroup;

    /**
     * 业务伙伴编号
     */
    @JsonProperty("PARTNER")
    private String partner;

    /**
     * 称谓代码
     */
    @JsonProperty("TITLE")
    private String title;

    /**
     * 组织名称 1
     */
    @JsonProperty("NAME_ORG1")
    private String nameOrg1;

    /**
     * 组织名称 2
     */
    @JsonProperty("NAME_ORG2")
    private String nameOrg2;

    /**
     * 组织名称 3
     */
    @JsonProperty("NAME_ORG3")
    private String nameOrg3;


    /**
     * 组织名称 4
     */
    @JsonProperty("NAME_ORG4")
    private String nameOrg4;

    /**
     * 业务伙伴的搜索词1
     */
    @JsonProperty("BU_SORT1")
    private String buSort1;

    /**
     * 业务伙伴的搜索词2
     */
    @JsonProperty("BU_SORT2")
    private String buSort2;


    /**
     * 街道
     */
    @JsonProperty("STREET")
    private String street;

    /**
     * 街道2
     */
    @JsonProperty("STR_SUPPL1")
    private String strSuppl1;

    /**
     * 街道3
     */
    @JsonProperty("STR_SUPPL2")
    private String strSuppl2;

    /**
     * 街道4
     */
    @JsonProperty("STR_SUPPL3")
    private String strSuppl3;

    /**
     * 国家/地区代码
     */
    @JsonProperty("LAND1")
    private String land1;

    /**
     * 国家/地区代码
     */
    @JsonProperty("REGION")
    private String region;

    /**
     * 语言关键字
     */
    @JsonProperty("LANGU")
    private String langu;

    /**
     * 语言关键字
     */
    @JsonProperty("CITY1")
    private String city1;

    /**
     * 城市邮政编码
     */
    @JsonProperty("POST_CODE1")
    private String postCode1;

    /**
     * 第一个电话号码
     */
    @JsonProperty("TEL_NUMBER")
    private String telNumber;

    /**
     * 一个电话号码:分机号
     */
    @JsonProperty("TEL_EXTENS")
    private String telExtens;

    /**
     * 第一个移动电话号码
     */
    @JsonProperty("MOB_NUMBER")
    private String mobNumber;

    /**
     * 第一个移动电话号码:分机
     */
    @JsonProperty("MOB_EXTENS")
    private String mobExtens;

    /**
     * 第一个传真号
     */
    @JsonProperty("FAX_NUMBER")
    private String faxNumber;

    /**
     * 第一个传真号：分机号
     */
    @JsonProperty("FAX_EXTENS")
    private String faxExtens;

    /**
     * 电子邮件地址
     */
    @JsonProperty("SMTP_ADDR")
    private String smtpAddr;

    /**
     * 供应商帐户组
     */
    @JsonProperty("KTOKK")
    private String ktokk;

    /**
     * 集中设置的采购冻结
     */
    @JsonProperty("SPERM")
    private String sperm;

    /**
     * 中心记帐冻结
     */
    @JsonProperty("SPERR")
    private String sperr;

    /**
     * 贸易合作伙伴的公司标识
     */
    @JsonProperty("VBUND")
    private String vbund;

    /**
     * 客户编号
     */
    @JsonProperty("KUNNR")
    private String kunnr;

    /**
     * 责任税务部门的税收编号
     */
    @JsonProperty("STENR")
    private String stenr;

    /**
     * 更新标识 I、U、D
     */
    @JsonProperty("UPDKZ")
    private String updkz;

    @JsonProperty("LFB1")
    private List<SuppliersPayVo>  suppliersPayList;

    @JsonProperty("LFM1")
    private List<SuppliersBuyerVo> suppliersBuyerList;

    @JsonProperty("BANK")
    private List<SuppliersBankVo>  suppliersBankList;

    @JsonProperty("LFM2")
    private List<SuppliersItemPeriodVo> suppliersItemPeriodVoList;
}