package com.huigou.topsun.sap.sapApplication.controller;

import com.huigou.topsun.sap.sapApplication.domain.query.SapDialogQuery;
import com.huigou.topsun.sap.sapApplication.application.SapMaterialApplication;
import com.huigou.topsun.sap.sapApplication.domain.vo.SapMaterialVo;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * @Auther: xin.lu
 * @Date: 2024/03/03/11:20
 * @Description: 选择SAP数据的dialog页面控制器
 */
@Controller
@ControllerMapping("sapDialogSelect")
public class SapDialogSelectController extends CommonController {
    @Autowired
    private SapMaterialApplication sapMaterialApplication;
    @Override
    protected String getPagePath() {
        return "/biz/topsun/sap/sapDialogSelect/";
    }

    public String forwardSapMaterial(){
        return forward("sapMaterial");
    }

    public String sapMaterialSelect() throws IOException {
        SDO sdo = this.getSDO();
        SapDialogQuery queryRequest = sdo.toObject(SapDialogQuery.class);
        List<Map<String,String>> sapMaterial = sapMaterialApplication.getSapMaterial(queryRequest);
        return packGridDataAndResult(sapMaterial);
    }
}
