package com.huigou.topsun.sap.salesOrder.application.impl;

import com.huigou.topsun.sap.salesOrder.application.SapSalesOrderApplication;

import com.huigou.topsun.sap.salesOrder.domain.SapSalesOrder;
import com.huigou.topsun.sap.salesOrder.domain.SapSalesOrderItem;
import com.huigou.topsun.sap.salesOrder.domain.SapSalesOrderOtherInfo;
import com.huigou.topsun.sap.salesOrder.repository.SapSalesOrderItemRepository;
import com.huigou.topsun.sap.salesOrder.repository.SapSalesOrderOtherInfoRepository;
import com.huigou.topsun.sap.salesOrder.repository.SapSalesOrderRepository;
import com.huigou.uasp.bpm.FlowBroker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


@Service
public class SapSalesOrderApplicationImpl extends FlowBroker implements SapSalesOrderApplication {
    @Autowired
    private SapSalesOrderRepository sapSalesOrderRepository;
    @Autowired
    private SapSalesOrderItemRepository sapSalesOrderItemRepository;
    @Autowired
    private SapSalesOrderOtherInfoRepository sapSalesOrderOtherInfoRepository;

    @Override
    public void saveSalesOrder(SapSalesOrder sapSalesOrder, SapSalesOrderItem sapSalesOrderItem, SapSalesOrderOtherInfo sapSalesOrderOtherInfo) {
        SapSalesOrder saveSapSalesOrder = sapSalesOrderRepository.saveAndFlush(sapSalesOrder);
        String salesOrderId = saveSapSalesOrder.getSalesOrderId();
        sapSalesOrderItem.setSalesOrderId(salesOrderId);
        SapSalesOrderItem saveSapSalesOrderItem = sapSalesOrderItemRepository.saveAndFlush(sapSalesOrderItem);
        String salesOrderItemId = saveSapSalesOrderItem.getSalesOrderItemId();
        sapSalesOrderOtherInfo.setSalesOrderItemId(salesOrderItemId);
        sapSalesOrderOtherInfo.setSalesOrderId(salesOrderId);
        SapSalesOrderOtherInfo saveSapSalesOrderOtherInfo = sapSalesOrderOtherInfoRepository.saveAndFlush(sapSalesOrderOtherInfo);
    }
}
