package com.huigou.topsun.sap.purchaseOrder.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.huigou.data.domain.model.AbstractEntity;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 
 * @TableName sap_purchase_order_item
 */
@Table(name="sap_purchase_order_item")
@Entity
@Data
@JsonIgnoreType
public class SapPurchaseOrderItem extends AbstractEntity {

    /**
     * 
     */
    @Column(name = "purchase_order_id")
    private String purchaseOrderId;

    /**
     * 项目编号
     */
    @Column(name = "EBELP")
    private String ebelp;

    /**
     * 项目类别
     */
    @Column(name = "PSTYP")
    private String pstyp;

    /**
     * 项目类别描述
     */
    @Column(name = "PTEXT")
    private String ptext;

    /**
     * 科目分配类别
     */
    @Column(name = "KNTTP")
    private String knttp;

    /**
     * 科目分配类别描述
     */
    @Column(name = "KNTTX")
    private String knttx;

    /**
     * 物料号
     */
    @Column(name = "MATNR")
    private String matnr;

    /**
     * 物料描述
     */
    @Column(name = "TXZ01")
    private String txz01;

    /**
     * 物料组
     */
    @Column(name = "MATKL")
    private String matkl;

    /**
     * 物料组描述
     */
    @Column(name = "WGBEZ")
    private String wgbez;

    /**
     * 采购订单数量
     */
    @Column(name = "MENGE")
    private String menge;

    /**
     * 采购订单计量单位
     */
    @Column(name = "MEINS")
    private String meins;

    /**
     * 单位描述
     */
    @Column(name = "MSEHL")
    private String msehl;

    /**
     * 要求交货日期
     */
    @Column(name = "EINDT")
    private Date eindt;

    /**
     * 工厂
     */
    @Column(name = "WERKS")
    private String werks;

    /**
     * 名称
     */
    @Column(name = "NAME1")
    private String name1;

    /**
     * 库存地点
     */
    @Column(name = "LGORT")
    private String lgort;

    /**
     * 库存地点的描述
     */
    @Column(name = "LGOBE")
    private String lgobe;


    /**
     * 价格
     */
    @Column(name = "NETPR")
    private BigDecimal netpr;

    /**
     * 价格单位
     */
    @Column(name = "PEINH")
    private Integer peinh;

    /**
     * 税码
     */
    @Column(name = "MWSKZ")
    private String mwskz;

    /**
     * 税率
     */
    @Column(name = "KBETR")
    private String kbetr;


    /**
     * 总价
     */
    @Column(name = "NETWR")
    private BigDecimal netwr;

    /**
     * 退货项目
     */
    @Column(name = "RETPO")
    private String retpo;

    /**
     * 免费项目
     */
    @Column(name = "UMSON")
    private String umson;

    /**
     * 总账科目
     */
    @Column(name = "SAKTO")
    private String sakto;

    /**
     * 成本中心
     */
    @Column(name = "KOSTL")
    private String kostl;

    /**
     * 主资产号
     */
    @Column(name = "ANLN1")
    private String anln1;

    /**
     * 资产次级编号
     */
    @Column(name = "ANLN2")
    private String anln2;

    /**
     * 销售单号
     */
    @Column(name = "VBELN")
    private String vbeln;

    /**
     * 销售单行项目
     */
    @Column(name = "POSNR")
    private String posnr;

    /**
     * 联系人电话
     */
    @Column(name = "TELF1")
    private String telf1;

    /**
     * 成品数量
     */
    @Column(name = "KWMENG")
    private BigDecimal kwmeng;

    /**
     * 指令号
     */
    @Column(name = "ZINSTNUM")
    private String zinstnum;

    /**
     * 产品编码
     */
    @Column(name = "MATNR2")
    private String matnr2;

    /**
     * 产品描述
     */
    @Column(name = "MAKTX")
    private String maktx;

    /**
     * 交货地址
     */
    @Column(name = "STR_SUPPL")
    private String strSuppl;

    /**
     * 运输费用
     */
    @Column(name = "KBETR2")
    private BigDecimal kbetr2;

    /**
     * 包装费用
     */
    @Column(name = "kbetr3")
    private BigDecimal kbetr3;

    /**
     * 包装要求
     */
    @Column(name="ZPACKREQU")
    private String  zpackrequ;

    /**
     * 包装数量
     */
    @Column(name="ZPACKREQUNUM")
    private String  zpackrequnum;

    /**
     * 包装单位
     */
    @Column(name="ZPACKUNIT")
    private String  zpackunit;

    /**
     * 是否组合单包装
     */
    @Column(name="ZLOSSPACK")
    private String  zlosspack;

    /**
     * 备注
     */
    @Column(name = "LTEXT")
    private String  ltext;

    /**
     * 删除标识
     */
    @Column(name = "LOEKZ")
    private String loekz;

    /**
     * 序列号
     */
    @Column(name = "SERNR")
    private String sernr;
}