package com.huigou.topsun.sap.purchaseOrder.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.huigou.data.domain.model.FlowBillAbstractEntity;
import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @TableName sap_purchase_order
 */
@Table(name = "sap_purchase_order")
@Entity
@Data
public class SapPurchaseOrder extends FlowBillAbstractEntity {


    /**
     * 采购订单号码
     */
    @Column(name = "EBELN")
    private String ebeln;

    /**
     * 采购订单类型
     */
    @Column(name = "BSART")
    private String bsart;

    /**
     * 采购订单类型描述
     */
    @Column(name = "BATXT")
    private String batxt;

    /**
     * 采购组
     */
    @Column(name = "EKGRP")
    private String ekgrp;

    /**
     * 采购组描述
     */
    @Column(name = "EKNAM")
    private String eknam;

    /**
     * 币种
     */
    @Column(name = "WAERS")
    private String waers;

    /**
     * 订单总金额
     */
    @Column(name = "total_money")
    private BigDecimal totalMoney;

//    /**
//     * 创建日期
//     */
//    @Column(name = "AEDAT")
//    private Date aedat;


//    /**
//     * 创建人ID创建人ID
//     */
//    @Column(name = "ERNAM")
//    private String ernam;
//
//    /**
//     * 创建人姓名
//     */
//    @Column(name = "NAME_TEXT")
//    private String nameText;

    /**
     * 消息类型
     */
    @Column(name = "MSG_TYPE")
    private String msgType;

    /**
     * 消息id
     */
    @Column(name = "MSG_ID")
    private String msgId;
    /**
     * 消息编号
     */
    @Column(name = "NUMBER")
    private String number;
    /**
     * 消息内容
     */
    @Column(name = "MESSAGE")
    private String message;
    /**
     * 日志编号
     */
    @Column(name = "LOG_NO")
    private String logNo;
    /**
     * 日志消息编号
     */
    @Column(name = "LOG_MSG_NO")
    private String logMsgNo;
    /**
     * 消息参数 1
     */
    @Column(name = "MESSAGE_V1")
    private String messageV1;
    /**
     * 消息参数 2
     */
    @Column(name = "MESSAGE_V2")
    private String messageV2;
    /**
     * 消息参数 3
     */
    @Column(name = "MESSAGE_V3")
    private String messageV3;
    /**
     * 消息参数 4
     */
    @Column(name = "MESSAGE_V4")
    private String messageV4;

//    /**
//     * 参数
//     */
//    @Column(name = "PARAMETER")
//    private String parameter;
//    /**
//     * 行数
//     */
//    @Column(name = "ROW")
//    private String row;
//    /**
//     * 字段
//     */
//    @Column(name = "FIELD")
//    private String field;
//    /**
//     * 系统
//     */
//    @Column(name = "SYSTEM")
//    private String system;
    @Column(name = "retpo")
     private String retpo;

    /**
     * 供应商名称
     */
    @Column(name = "NAMEL")
    private String namel;

    /**
     * 供应商编码
     */
    @Column(name = "LIFNR")
    private String lifnr;

    /**
     * 已外发 1
     */
    @Column(name = "send_out")
    private String sendOut;

    @Column(name = "HEAD_TEXT")
    private String headText;

    /**
     * 科目分配类别
     */
    @Column(name = "KNTTP")
    private String knttp;

    /**
     * 撤审原因
     */
    @Column(name = "revoke_reason")
    private String revokeReason;

    /**
     * 撤审类型
     */
    @Column(name = "order_revoke_type")
    private String orderRevokeType;

    @Override
    protected String getCodeRuleId() {
        return "sapPurchaseOrder";
    }

}