package com.huigou.topsun.sap.purchaseOrder.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.huigou.topsun.common.BillStatus;
import com.huigou.topsun.sap.processOutsource.domain.ProcessOutsourceOrderItem;
import com.huigou.topsun.sap.processOutsource.repository.ProcessOutsourceOrderItemRepository;
import com.huigou.topsun.sap.purchaseOrder.application.SapPurchaseOrderApplication;
import com.huigou.topsun.sap.purchaseOrder.application.SapPurchaseOrderItemApplication;
import com.huigou.topsun.sap.purchaseOrder.domain.SapPurchaseOrder;
import com.huigou.topsun.sap.purchaseOrder.domain.query.SapPurchaseOrderItemQueryRequest;
import com.huigou.topsun.sap.purchaseOrder.domain.query.SapPurchaseOrderQueryRequest;
import com.huigou.topsun.sap.purchaseOrder.domain.vo.SapPurchaseOrderDto;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.annotation.SkipAuth;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.JSONUtil;
import com.huigou.util.SDO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @Auther: xin.lu
 * @Date: 2024/01/09/18:58
 * @Description:
 */
@Controller
@ControllerMapping("/sapPurchaseOrder")
public class SapPurchaseOrderController extends CommonController {
    private final static Logger LOG = LoggerFactory.getLogger(SapPurchaseOrderController.class);
    @Resource
    private SapPurchaseOrderItemApplication sapPurchaseOrderItemApplication;
    @Resource
    private SapPurchaseOrderApplication sapPurchaseOrderApplication;
    @Resource
    private ProcessOutsourceOrderItemRepository processOutsourceOrderItemRepository;

    @Override
    protected String getPagePath() {
        return "/biz/topsun/sap/purchaseOrder/";
    }

    @SkipAuth
    @RequestMapping( value = "/getSapPurchaseOrder",consumes = "application/json; charset=UTF-8", produces = "application/json; charset=UTF-8")
    @ResponseBody
    public HashMap<String, Object> getSapPurchaseOrder(@RequestBody SapPurchaseOrderDto sapPurchaseOrderDto){
        LOG.info("SAP采购订单审批数据=={}", JSONUtil.toString(sapPurchaseOrderDto));
        //System.out.println(sapPurchaseOrderDto);
        HashMap<String, Object> messageMap = new HashMap<>();
        messageMap.put("CODE","S");
        messageMap.put("MSG","成功");
        messageMap.put("DATA",sapPurchaseOrderDto.getLsHeader().getEbeln());
        try {
            this.sapPurchaseOrderApplication.saveSapPurchaseOrderDto(sapPurchaseOrderDto);
        }catch (RuntimeException e){
            messageMap.put("CODE","E");
            messageMap.put("MSG",e.getMessage());
            messageMap.put("DATA",sapPurchaseOrderDto.getLsHeader().getEbeln());
        }
        return messageMap;
    }


    public String forwardSapPurchaseOrderList(){
        this.putAttribute("statusKindsList", BillStatus.getValidMap());
        this.putAttribute("loginId",this.getOperator().getPersonMemberId());
        return forward("sapPurchaseOrderList");
    }

    public String slicedSapPurchaseOrderList(){
        SDO sdo = this.getSDO();
        SapPurchaseOrderQueryRequest queryRequest = sdo.toQueryRequest(SapPurchaseOrderQueryRequest.class);
        Map<String, Object> map = sapPurchaseOrderApplication.slicedSapPurchaseOrderList(queryRequest);
        return toResult(map);
    }

    public String showSapPurchaseOrderDetail(){
        SDO sdo = this.getSDO();
        String id = sdo.getBizId();
        SapPurchaseOrder sapPurchaseOrder = sapPurchaseOrderApplication.loadSapPurchaseOrder(id);

        //根据采购订单号，查询工序外协组件信息
        String ebeln = sapPurchaseOrder.getEbeln();
        List<ProcessOutsourceOrderItem> orderItemList = processOutsourceOrderItemRepository.findByEbeln(ebeln);
        if (CollectionUtil.isNotEmpty(orderItemList)){
            String processOutsourceId = orderItemList
                    .stream()
                    .map(ProcessOutsourceOrderItem::getProcessOutsourceId)
                    .findFirst()
                    .get();
            this.putAttribute("processOutsourceId",processOutsourceId);
        }
        return forward("sapPurchaseOrderDetail",sapPurchaseOrder);
    }

    public String querySapPurchaseOrderItems(){
        SDO sdo = this.getSDO();
        SapPurchaseOrderItemQueryRequest queryRequest = sdo.toQueryRequest(SapPurchaseOrderItemQueryRequest.class);
        Map<String, Object> map = sapPurchaseOrderItemApplication.querySapPurchaseOrderItems(queryRequest);
        return toResult(map);
    }

    //撤销审批
    public String revokeApproval(){
        SDO sdo = this.getSDO();
        String id=sdo.getString("id");
        String revokeReason=sdo.getString("revokeReason");
        String revokeType=sdo.getString("orderRevokeType");
        String newId=sapPurchaseOrderApplication.revokeApproval(id,revokeReason,revokeType);
        return success();
    }

    /**
     * 打印
     * @return
     */
    public String print() {
        SDO sdo = this.getSDO();
        String id = sdo.getId();
        Integer num = sdo.getInteger("j");
        Map<String,Object> map = this.sapPurchaseOrderApplication.print(id,num);
        String pintPage = "/print/topsun/processOuter2.ftl";
        return outputAndProcUnitHandlerPDF(pintPage, id, map);
    }

    /**
     * 打印带生产单号
     * @return
     */
    public String printProduceNo() {
        SDO sdo = this.getSDO();
        String id = sdo.getId();
        Integer num = sdo.getInteger("j");
        Map<String,Object> map = this.sapPurchaseOrderApplication.print(id,num);
        String pintPage = "/print/topsun/processOuter.ftl";
        return outputAndProcUnitHandlerPDF(pintPage, id, map);
    }

    /**
     * 更改外发状态
     * @return
     */
    public String sendOutProcess(){
        SDO sdo = this.getSDO();
        List<String> ids = sdo.getIds();
        sapPurchaseOrderApplication.updateProcessOutStatus(ids);
        return success();
    }

    /**
     * 强制删除待办
     * @return
     */
    public String forceAbortPurchaseOrder(){
        SDO sdo = this.getSDO();
        String id = sdo.getId();
        //任务ID
        String jobPageId = sdo.getString("jobPageId");
        sapPurchaseOrderApplication.abortPurchaseOrder(id, jobPageId);
        return success();
    }

    public String showRevokeDetail(){
        SDO sdo = this.getSDO();
        String id = sdo.getId();
        this.putAttribute("id",id);
        return forward("showRevokeDetail");
    }
}
