package com.huigou.topsun.sap.purchaseInfoRecord.domain.vo;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Column;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Auther: xin.lu
 * @Date: 2024/02/28/15:35
 * @Description:
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class SapPurchaseInfoRecordItemVo implements Serializable {
    /**
     * 采购信息记录号
     */
    @JsonProperty("INFNR")
    private String infnr;

    /**
     * 定价条件号
     */
    @JsonProperty("KNUMH")
    private String knumh;

    /**
     * 采购组织
     */
    @JsonProperty("EKORG")
    private String ekorg;
    /**
     * 供应商
     */
    @JsonProperty("LIFNR")
    private String lifnr;
    /**
     * 名称 1
     */
    @JsonProperty("NAME1")
    private String name1;
    /**
     * 物料编码
     */
    @JsonProperty("MATNR")
    private String matnr;
    /**
     * 物料描述
     */
    @JsonProperty("MAKTX")
    private String maktx;
    /**
     * 物料组
     */
    @JsonProperty("MATKL")
    private String matkl;
    /**
     * 采购信息记录分类
     */
    @JsonProperty("ESOKZ")
    private String esokz;
    /**
     * 采购组
     */
    @JsonProperty("EKGRP")
    private String ekgrp;
    /**
     * 工厂
     */
    @JsonProperty("WERKS")
    private String werks;
    /**
     * 生产版本
     */
    @JsonProperty("VERID")
    private String verid;
    /**
     * 净价
     */
    @JsonProperty("NETPR")
    private BigDecimal netpr;
    /**
     * 货币码
     */
    @JsonProperty("WAERS")
    private String waers;

    /**
     * 供应商子范围
     */
    @JsonProperty("LTSNR")
    private String ltsnr;

    /**
     * 供应商子范围描述
     */
    @JsonProperty("LTSBZ")
    private String ltsbz;
    /**
     * 价格单位
     */
    @JsonProperty("PEINH")
    private String peinh;
    /**
     * 订单价格单位(采购)
     */
    @JsonProperty("BPRME")
    private String bprme;
    /**
     * 销售/购买税代码
     */
    @JsonProperty("MWSKZ")
    private String mwskz;
    /**
     * 开始生效日期
     */
    @JsonProperty("DATAB")
    private String datab;
    /**
     * 有效期至日期
     */
    @JsonProperty("DATBI")
    private String datbi;
    /**
     * 条件等级数量
     */
    @JsonProperty("KSTBM")
    private BigDecimal kstbm;

    /**
     * 等级金额1
     */
    @JsonProperty("KBETR1")
    private BigDecimal kbetr;

    /**
     * 条件等级数量2
     */
    @JsonProperty("KSTBM2")
    private BigDecimal kstbm2;

    /**
     * 等级金额2
     */
    @JsonProperty("KBETR2")
    private BigDecimal kbetr2;

    /**
     * 条件等级数量3
     */
    @JsonProperty("KSTBM3")
    private BigDecimal kstbm3;

    /**
     * 等级金额3
     */
    @JsonProperty("KBETR3")
    private BigDecimal kbetr3;

    /**
     * 条件等级数量4
     */
    @JsonProperty("KSTBM4")
    private BigDecimal kstbm4;

    /**
     * 等级金额4
     */
    @JsonProperty("KBETR4")
    private BigDecimal kbetr4;


    /**
     * 条件等级数量5
     */
    @JsonProperty("KSTBM5")
    private BigDecimal kstbm5;

    /**
     * 等级金额5
     */
    @JsonProperty("KBETR5")
    private BigDecimal kbetr5;


    /**
     * 销售员
     */
    @JsonProperty("VERKF")
    private String verkf;
    /**
     * 电话
     */
    @JsonProperty("TELF1")
    private String telf1;
    /**
     * 基本计量单位
     */
    @JsonProperty("MEINS")
    private String meins;
    /**
     * 订单单位到基本单位转换的分母
     */
    @JsonProperty("UMREN")
    private BigDecimal umren;
    /**
     * 基本计量单位转换分子
     */
    @JsonProperty("UMREZ")
    private BigDecimal umrez;
    /**
     * 原产地国
     */
    @JsonProperty("URZLA")
    private String urzla;
    /**
     * 地区
     */
    @JsonProperty("REGIO")
    private String regio;
    /**
     * 删除标志
     */
    @JsonProperty("LOEKZ")
    private String loekz;
    /**
     * 排序字段
     */
    @JsonProperty("SORTL")
    private String sortl;
    /**
     * 标准采购订单数量
     */
    @JsonProperty("NORBM")
    private BigDecimal norbm;
    /**
     * 最小采购订单数量
     */
    @JsonProperty("MINBM")
    private BigDecimal minbm;
    /**
     * 等级类型
     */
    @JsonProperty("STFKZ")
    private String stfkz;
    /**
     * 计划交货时间（天）
     */
    @JsonProperty("APLFZ")
    private Date aplfz;

    /**
     * 运输费
     */
    @JsonProperty("KBETR")
    private BigDecimal freight;

    /**
     * 包装费
     */
    @JsonProperty("KBETR6")
    private BigDecimal kbetr6;

    /**
     * 短文本
     */
    @JsonProperty("TXZ01")
    private String txz01;


    /**
     * （报价失效标志），值范围：X（是），空（否）
     */
    @JsonProperty("ZZF")
    private String zzf;

    @JsonProperty("UNTTO")
    private BigDecimal untto;

    @JsonProperty("UEBTO")
    private BigDecimal uebto;

}
