package com.huigou.topsun.sap.purchaseApproval.controller;

import com.huigou.topsun.sap.purchaseApproval.application.SapPurchaseApprovalItemApplication;
import com.huigou.topsun.sap.purchaseApproval.domain.query.SapPurchaseApprovalItemQueryRequest;
import com.huigou.topsun.sap.purchaseApproval.repository.SapPurchaseApprovalItemRepository;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import org.springframework.stereotype.Controller;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * @Auther: xin.lu
 * @Date: 2023/12/27/17:24
 * @Description:
 */
@Controller
@ControllerMapping("/sapPurchaseApprovalItem")
public class SapPurchaseApprovalItemController extends CommonController {
    @Resource
    private SapPurchaseApprovalItemApplication sapPurchaseApprovalItemApplication;
    @Resource
    private SapPurchaseApprovalItemRepository sapPurchaseApprovalItemRepository;

    public String querySapPurchaseApprovalItems(){
        SDO sdo = this.getSDO();
        SapPurchaseApprovalItemQueryRequest queryRequest = sdo.toQueryRequest(SapPurchaseApprovalItemQueryRequest.class);
        Map<String, Object> map = sapPurchaseApprovalItemApplication.querySapPurchaseApprovalItems(queryRequest);
        return toResult(map);
    }

    public String deleteSapPurchaseApprovalItem(){
        SDO sdo = this.getSDO();
        List<String> ids = sdo.getIds();
        sapPurchaseApprovalItemApplication.deleteByIds(ids);
        return success();
    }

}
