package com.huigou.topsun.sap.produceSupplierReview.domain;

import com.huigou.data.domain.model.FlowBillAbstractEntity;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.util.Date;

/**
 * @Auther: xin.lu
 * @Date: 2024/06/03/10:43
 * @Description: 生产类供应商准入评审表-供方调查表
 */
@Entity
@Data
@Table(name = "sap_produce_supplier_review")
public class ProduceSupplierReview extends FlowBillAbstractEntity {

    /**
     * 供应商名称
     */
    @Column(name = "name")
    private String name;

    /**
     * 电话号码
     */
    @Column(name = "tel")
    private String tel;

    /**
     * 公司地址
     */
    @Column(name = "address")
    private String address;

    /**
     * 传真号码
     */
    @Column(name = "fax")
    private String fax;

    /**
     * 公司性质
     */
    @Column(name = "company_nature")
    private String companyNature;

    /**
     * 业务联系人
     */
    @Column(name = "business_contact")
    private String businessContact;

    /**
     * 公司负责人
     */
    @Column(name = "responsible_person")
    private String responsiblePerson;

    /**
     * 公司占地面积
     */
    @Column(name = "occupied_area")
    private String occupiedArea;

    /**
     * 生产能力
     */
    @Column(name = "capacity")
    private String capacity;

    /**
     * 公司总人数
     */
    @Column(name = "total_employees")
    private String totalEmployees;

    /**
     * 管理总人数
     */
    @Column(name = "management_persons")
    private String managementPersons;

    /**
     * 品管总人数
     */
    @Column(name = "qc_persons")
    private String qcPersons;

    /**
     * 公司营业执照
     */
    @Column(name = "business_license")
    private String businessLicense;

    /**
     * 税务登记证
     */
    @Column(name = "tax_license")
    private String taxLicense;

    /**
     * 公司主要产品
     */
    @Column(name = "main_products")
    private String mainProducts;

    /**
     * 取得何种管理体系认证(□ISO9001   □ISO14001   □其它 Others)
     */
    @Column(name = "management_system_certifications")
    private String managementSystemCertifications;

    /**
     * 综合评价1
     */
    @Column(name = "comprehensive_assessment1")
    private String comprehensiveAssessment1;

    /**
     * 生产及检测设备
     */
    @Column(name = "production_test_machines")
    private String productionTestMachines;

    /**
     * 生产能力
     */
    @Column(name = "production_capacity")
    private String productionCapacity;

    /**
     * 交货能力
     */
    @Column(name = "deliver_capacity")
    private String deliverCapacity;

    /**
     * 代理资格及代理品牌（贸易型)
     */
    @Column(name = "agent_rights_brands")
    private String agentRightsBrands;

    /**
     * 样品的评估结果
     */
    @Column(name = "sample_evaluation_result")
    private String sampleEvaluationResult;

    /**
     * 部门/评估人1
     */
    @Column(name = "dept_evaluator1")
    private String deptEvaluator1;

    /**
     * 单价及合理性
     */
    @Column(name = "price_reasonability")
    private String priceReasonability;

    /**
     * 部门/评估人
     */
    @Column(name = "dept_evaluator2")
    private String deptEvaluator2;

    /**
     * 综合评估
     */
    @Column(name = "comprehensive_assessment")
    private String comprehensiveAssessment;

    /**
     * 是否试用月份
     */
    @Column(name = "is_trial_for_month")
    private String isTrialForMonth;

    /**
     * 试用月份数量
     */
    @Column(name = "trial_for_month")
    private String trialForMonth;

    /**
     * 是否安排实地考察
     */
    @Column(name = "is_onsite_audit")
    private String isOnsiteAudit;

    /**
     * 是否录入合格供方
     */
    @Column(name = "is_approved_supplier")
    private String isApprovedSupplier;

    /**
     * 产品名称及类别
     */
    @Column(name = "product_name_and_type")
    private String productNameAndType;

    /**
     * 评审日期
     */
    @Column(name = "review_date")
    private Date reviewDate;

    /**
     * 总得分
     */
    @Column(name = "quality_sum")
    private String qualitySum;

    /**
     * 品质得分=（总得分/110）*100
     */
    @Column(name = "quality_total")
    private String qualityTotal;

    /**
     * 稽核人/日期：
     */
    @Column(name = "quality_review")
    private String qualityReview;

    /**
     * 总得分
     */
    @Column(name = "project_sum")
    private String projectSum;

    /**
     * 工程评分=（总得分/18）*100
     */
    @Column(name = "project_total")
    private String projectTotal;

    /**
     * 稽核人/日期
     */
    @Column(name = "project_review")
    private String projectReview;

    /**
     * 采购评分=以上三项目总和/3=
     */
    @Column(name = "purchase_sum")
    private String purchaseSum;

    /**
     * 最终得分=品管评分*35%+工程评分子量35%+采购评分*30%=
     */
    @Column(name = "final_sum")
    private String finalSum;

    /**
     * 最终评审结果
     */
    @Column(name = "final_result")
    private String finalResult;

    /**
     * 最终评审处理决定
     */
    @Column(name = "final_review_deal_result")
    private String finalReviewDealResult;

    @Column(name = "attbiz_id")
    private String attbizId;
    @Override
    protected String getCodeRuleId() {
        return "produceSupplierReview";
    }
}
