package com.huigou.topsun.sap.produceSupplierReview.controller;

import com.huigou.context.Operator;
import com.huigou.context.OrgUnit;
import com.huigou.data.domain.query.QueryPageRequest;
import com.huigou.topsun.sap.produceSupplierReview.application.ProduceSupplierReviewApplication;
import com.huigou.topsun.sap.produceSupplierReview.domain.ProduceSupplierReview;
import com.huigou.topsun.sap.produceSupplierReview.domain.query.ProduceSupplierReviewQueryRequest;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.bmp.common.BizBillStatus;
import com.huigou.uasp.bmp.doc.attachment.application.AttachmentApplication;
import com.huigou.uasp.bmp.doc.attachment.domain.model.Attachment;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.CommonUtil;
import com.huigou.util.Constants;
import com.huigou.util.SDO;
import com.huigou.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Auther: xin.lu
 * @Date: 2024/06/03/14:33
 * @Description:
 */
@Controller
@ControllerMapping("/produceSupplierReview")
public class ProduceSupplierReviewController extends CommonController {
    @Override
    protected String getPagePath() {
        return "/biz/topsun/sap/produceSupplierReview/";
    }

    @Resource
    private ProduceSupplierReviewApplication produceSupplierReviewApplication;
    @Autowired
    private AttachmentApplication attachmentApplication;

    public String forwardProduceSupplierReviewList(){
        return forward("produceSupplierReviewList");
    }

    public String slicedProduceSupplierReviewList(){
        SDO sdo = this.getSDO();
        ProduceSupplierReviewQueryRequest queryRequest = sdo.toQueryRequest(ProduceSupplierReviewQueryRequest.class);
        Map<String, Object> map = produceSupplierReviewApplication.slicedProduceSupplierReviewList(queryRequest);
        return toResult(map);
    }

    public String slicedNewSupplierReviewItemList(){
        SDO sdo = this.getSDO();
        ProduceSupplierReviewQueryRequest queryRequest = sdo.toQueryRequest(ProduceSupplierReviewQueryRequest.class);
        QueryPageRequest pageModel = queryRequest.getPageModel();
        pageModel.setPageSize(200);
        queryRequest.setPageModel(pageModel);
        Map<String, Object> map = new HashMap<>();
        if (StringUtil.isNotBlank(queryRequest.getNewSupplierReviewId())){
           map  = produceSupplierReviewApplication.slicedProduceSupplierReviewItemList(queryRequest);
        }else {
            map  = produceSupplierReviewApplication.slicedNewSupplierReviewItemTypeList(queryRequest);
        }
        return toResult(map);
    }

    public String forwardProduceSupplierReviewDetail(){
        this.putAttribute("processDefinitionKey", ProduceSupplierReviewApplication.PROCESS_DEFINITION_KEY);
        // 新增的时候procUnitId一定要设置成Apply，不然jsp页面的所有表单元素是readonly状态
        this.putAttribute("procUnitId", "Apply");
        ProduceSupplierReview produceSupplierReview = new ProduceSupplierReview();
        produceSupplierReview.setStatusId(BizBillStatus.APPLYING.getId());
        produceSupplierReview.setAttbizId(CommonUtil.createGUID()); // 自动生成附件id
        /**
         * 设置jsp页面初始化填充数据，如果不设置， 那么在jsp页面上填写完表单之后立即提交申请TaskDescription获取不到时间和相关人员信息
         */
        Operator operator = getOperator();
        produceSupplierReview.setDefaultValues(new OrgUnit(operator.getFullId(), operator.getFullName()));
        return forward("produceSupplierReviewDetail",produceSupplierReview);
    }

    public String showProduceSupplierReviewDetail(){
        SDO sdo = this.getSDO();
        String id = sdo.getBizId();
        ProduceSupplierReview produceSupplierReview = produceSupplierReviewApplication.findProduceSupplierReviewById(id);
        List<Attachment> businessLicenses = attachmentApplication.queryAttachments("businessLicensePicture", id);

        if (businessLicenses.size() > 0) {
            Attachment attachment = businessLicenses.get(0);
            produceSupplierReview.setBusinessLicense(StringUtil.encode(attachment.getPath()));
        }
        List<Attachment> taxLicenses = attachmentApplication.queryAttachments("taxLicensePicture", id);

        if (taxLicenses.size() > 0) {
            Attachment attachment = taxLicenses.get(0);
            produceSupplierReview.setTaxLicense(StringUtil.encode(attachment.getPath()));
        }
        return forward("produceSupplierReviewDetail",produceSupplierReview);
    }
}
