package com.huigou.topsun.sap.processOutsource.domain;

import com.huigou.data.domain.model.AbstractEntity;
import com.huigou.data.domain.model.FlowBillAbstractEntity;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Auther: xin.lu
 * @Date: 2024/08/02/9:42
 * @Description: 工序外协申请单订单明细
 */
@Data
@Entity
@Table(name = "sap_process_outsource_order_item")
public class ProcessOutsourceOrderItem extends AbstractEntity {
    @Column(name = "process_outsource_id")
    private String processOutsourceId;

    /**
     * SAP采购订单
     */
    @Column(name = "EBELN")
    private String ebeln;

    /**
     * 订单行项目号
     */
    @Column(name = "EBELP")
    private String ebelp;
    /**
     * 序号
     */
    @Column(name = "sequence")
    private String sequence;


    /**
     * 工单
     */
    @Column(name = "AUFNR")
    private String aufnr;

    /**
     * 工序号
     */
    @Column(name = "WEMPF")
    private String wempf;

    /**
     * 工序描述
     */
    @Column(name = "TXZ01")
    private String txz01;

    /**
     * 下道工序
     */
    @Column(name = "TXZ02")
    private String txz02;

    /**
     * 同一工序外发次数
     * 自动计数器，匹配条件为“如果之前状态为通过的申请中有相同工单+工序，则计数器+1，起始为1”
     */
    @Column(name = "ABLAD")
    private String ablad;

    /**
     * 数量
     */
    @Column(name = "MENGE")
    private BigDecimal menge;

    /**
     * LOSS数
     * */
    @Column(name = "print_loss")
    private BigDecimal printLoss;

    /**
     * 单位
     */
    @Column(name = "MEINS")
    private String meins;

    /**
     * 单位描述
     */
    @Column(name = "MEINS_NAME")
    private String meinsName;

    /**
     * 存储地点
     */
    @Column(name = "LGORT")
    private String lgort;

    /**
     * 存储地点
     */
    @Column(name = "LGORT_NAME")
    private String lgortName;

    /**
     * 交货日期
     */
    @Column(name = "EEIND")
    private Date eeind;

    /**
     * 供应商编码
     */
    @Column(name = "LIFNR")
    private String lifnr;

    /**
     * 供应商名称
     */
    @Column(name = "LIFNR_NAME")
    private String lifnrName;

    /**
     * 单价
     */
    @Column(name = "KBETR")
    private BigDecimal kbetr;

    /**
     * 税码
     */
    @Column(name = "PURCHASE_MWSKZ")
    private String purchaseMwskz;

    /**
     * 定价基数 默认为1，可修改
     */
    @Column(name = "KPEIN")
    private BigDecimal kpein;

    /**
     * 币别
     */
    @Column(name = "WAERS")
    private String waers;

    /**
     * 产品编码
     */
    @Column(name = "PRODUCT_CODE")
    private String productCode;

    /**
     * 产品名称
     */
    @Column(name = "PRODUCT_NAME")
    private String productName;

    /**
     * 产品类别
     */
    @Column(name = "PRODUCT_TYPE")
    private String productType;

    /**
     * 产品类别描述
     */
    @Column(name = "PRODUCT_TYPE_NAME")
    private String productTypeName;

    /**
     * 总价
     */
    @Column(name = "amount")
    private BigDecimal amount;

    /**
     * 需求日期
     */
    @Column(name = "BEDAT")
    private Date bedat;

    /**
     * 备注
     */
    @Column(name = "remark")
    private String remark;

    //UEBTK（未限制的过量收货），默认赋值：X=是，（值范围：X=是，空=否）
    @Column(name = "UEBTK")
    private String uebtk;

}
