package com.huigou.topsun.sap.processOutsource.application.impl;

import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.data.query.model.QueryModel;
import com.huigou.topsun.sap.processOutsource.application.ProcessOutsourceOrderItemApplication;
import com.huigou.topsun.sap.processOutsource.domain.ProcessOutsourceOrderItem;
import com.huigou.topsun.sap.processOutsource.domain.query.ProcessOutsourceQueryRequest;
import com.huigou.topsun.sap.processOutsource.repository.ProcessOutsourceOrderItemRepository;
import com.huigou.uasp.bmp.common.application.BaseApplication;
import com.huigou.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Auther: xin.lu
 * @Date: 2024/08/02/10:02
 * @Description:
 */
@Service("processOutsourceOrderItemApplication")
public class ProcessOutsourceOrderItemApplicationImpl extends BaseApplication implements ProcessOutsourceOrderItemApplication {
    @Autowired
    private ProcessOutsourceOrderItemRepository processOutsourceOrderItemRepository;
    @Override
    public void saveProcessOutsourceOrderItems(String processOutsourceOrderItemId, List<ProcessOutsourceOrderItem> processOutsourceOrderItemItems) {
        processOutsourceOrderItemItems.forEach(processOutsourceOrderItemItem->{
            processOutsourceOrderItemItem.setProcessOutsourceId(processOutsourceOrderItemId);
            processOutsourceOrderItemRepository.save(processOutsourceOrderItemItem);
        });
    }

    @Override
    public Map<String, Object> queryProcessOutsourceOrderItems(ProcessOutsourceQueryRequest queryRequest) {
        Map<String, Object> map = new HashMap<>();
        if (StringUtil.isNotBlank(queryRequest.getProcessOutsourceId())){
            QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "processOutsourceOrderItems");
            QueryModel queryModel = this.sqlExecutorDao.getQueryModel(queryDescriptor, queryRequest);
            map = this.sqlExecutorDao.executeSlicedQuery(queryModel);
        }
        return map;
    }

    @Override
    public void deleteByIds(List<String> ids) {
        ids.forEach(id->{
            processOutsourceOrderItemRepository.delete(id);
        });
    }

    @Override
    public List<ProcessOutsourceOrderItem> findByProcessOutsourceId(String processOutsourceId) {
        return processOutsourceOrderItemRepository.findByProcessOutsourceId(processOutsourceId);
    }
    
}
