package com.huigou.topsun.sap.nonProdApply.domain;

import com.alibaba.fastjson.annotation.JSONField;
import com.huigou.data.domain.model.FlowBillAbstractEntity;
import lombok.Data;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.*;
import java.util.Date;

/**
 * 非产品/非半成品类物料主数据维护申请基础表
 * @TableName non_prod_apply_base_info
 */
@Table(name="sap_non_prod_apply_base_info")
@Data
@Entity
public class NonProdApplyBaseInfo extends FlowBillAbstractEntity {

    /**
     * 维护类型 ：new 新建 modify 变更 extend 扩展
     */
    @Column(name = "maintenance_type")
    private String maintenanceType;

    /**
     * 批准状态
     */
    @Column(name = "approval_status")
    private String approvalStatus;

    /**
     * 批准人
     */
    private String approver;

    /**
     * 批准日期
     */
    @Column(name = "approval_date")
    private Date approvalDate;

    /**
     * 通用品名
     */
    @Column(name = "generic_name")
    private String genericName;

    /**
     * 适用标准
     */
    @Column(name = "applicable_standard")
    private String applicableStandard;

    /**
     * 基本计量单位
     */
    @Column(name = "base_unit")
    private String baseUnit;

    /**
     * 规格
     */
    private String specifications;

    /**
     * 材质
     */
    private String material;

    /**
     * 版式
     */
    private String design;

    /**
     * 尺码
     */
    private String size;

    /**
     * 品牌
     */
    private String brand;
    /**
     * 品牌名称
     */
    @Column(name = "brand_name")
    private String brandName;
    /**
     * 用途
     */
    @Column(name = "material_usage")
    private String materialUsage;

    /**
     * 物品属性
     */
    @Column(name = "item_attributes")
    private String itemAttributes;

    /**
     * 业务用途
     */
    @Column(name = "business_usage")
    private String businessUsage;

    /**
     * 情况说明
     */
    @Column(name = "text_description")
    private String textDescription;

    /**
     * 中文文本说明
     */
    @Column(name = "maktx_rem_zh")
    private String maktxRemZh;
    /**
     * 英文文本说明
     */
    @Column(name = "maktx_rem_en")
    private String maktxRemEn;



    @Column(name ="created_date")
    @CreatedDate
    @JSONField(format="yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createdDate;

    @Override
    protected String getCodeRuleId() {
        return "sapNonProdApply";
    }

    //变更和扩展的数据来源ID
    @Column(name = "source_id")
    private String sourceId;


    //materiel表示物料 /product 产品
    @Column(name = "kind")
    private String kind;

   //处理状态：  0 待提交  2 已办结
    @Column(name = "distribute")
    private Integer distribute;



    @Column(name = "attbiz_id")
    private String attbizId;

    @Column(name = "base_unit_name")
    private String baseUnitName;

    @Transient
    private String applyType;

    @Transient
    private String applyDeptId;
    @Transient
    private String matnr;

    //CHECK_FLAG，检查标识（传 'X'：检查，空：创建
    @Transient
    private String checkFlag;

    /**
     * 扩展时显示已选择的业务用途
     */
    @Transient
    private String businessUsageSeled;

    /**
     * 1是 ，0 否
     */
    @Column(name = "is_extend_org")
    private String isExtendOrg;


}