package com.huigou.topsun.sap.nonProdApply.application;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.huigou.context.Operator;
import com.huigou.topsun.sap.nonProdApply.domain.NonProdApplyBaseInfo;
import com.huigou.topsun.sap.nonProdApply.domain.SapNonProdApplyDept;
import com.huigou.topsun.sap.nonProdApply.domain.query.NonProdApplyBaseInfoQueryRequest;
import com.huigou.util.SDO;

import java.util.List;
import java.util.Map;

public interface NonProdApplyDeptApplication {



    String QUERY_XML_FILE_PATH="config/topsun/sap/nonProdApply/nonProdApplyBaseInfo.xml";


    /**
     * 编辑详细信息
     * @param sdo
     */
    Map<String,Object> saveSapNonProdApplyDept(SDO sdo);

    SapNonProdApplyDept save(SapNonProdApplyDept sapNonProdApplyDept);

    /**
     * 更改分发状态
     * @param sdo
     */
   void distributeSapNonProdApplyDept(SDO sdo);

    SapNonProdApplyDept getNonProdApplyDeptById(String id);

    SapNonProdApplyDept getNonProdApplyDeptByBaseInfoId(String id);

    List<SapNonProdApplyDept> getNonProdApplyDeptByMatnr(String matnr);

    void deleteSapNonProdApplyDept(SapNonProdApplyDept sapNonProdApplyDept);
    /**
     * 驳回相关的部门
     * @param sdo
     */
    void rejectNonProdApplyDept(SDO sdo);

   //保存部门分发信息
    void saveDeptStaff(List<Map<String, String>> deptStaffList,String bussinessId,String genericName);
    //保存待办消息
    void saveBsnMessageData(NonProdApplyBaseInfo baseInfo,Map<String,Object> backMap);

    //冻结或解冻物料状态
    void unfreezeMaterialStatus(List<String> ids);

    /**
     * 根据物料编码查询客户名称
     * @param matnr
     * @return
     */
    String queryKunnrNameByMatnr(String matnr);
}