package com.huigou.topsun.sap.nonOrderStorage.controller;

import com.huigou.context.Operator;
import com.huigou.context.OrgUnit;
import com.huigou.topsun.sap.nonOrderStorage.application.NonOrderStorageApplication;
import com.huigou.topsun.sap.nonOrderStorage.domain.NonOrderStorage;
import com.huigou.topsun.sap.nonOrderStorage.domain.query.NonOrderStorageQueryRequest;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.bmp.common.BizBillStatus;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import java.util.List;

/**
 * @Auther: xin.lu
 * @Date: 2024/03/20/14:09
 * @Description:
 */
@Controller
@ControllerMapping("/nonOrderStorage")
public class NonOrderStorageController extends CommonController {
    @Autowired
    private NonOrderStorageApplication nonOrderStorageApplication;
    @Override
    protected String getPagePath() {
        return "/biz/topsun/sap/nonOrderStorage/";
    }

    public String forwardNonOrderStorageList() {
        return forward("nonOrderStorageList");
    }

    public String slicedNonOrderStorageList() {
        SDO sdo = this.getSDO();
        NonOrderStorageQueryRequest NonOrderStorageQueryRequest = sdo.toQueryRequest(NonOrderStorageQueryRequest.class);
        return toResult(nonOrderStorageApplication.slicedNonOrderStorageList(NonOrderStorageQueryRequest));
    }


    /**
     * 跳转到新增页面
     */
    public String addNonOrderStorageDetail() {
        this.putAttribute("processDefinitionKey", NonOrderStorageApplication.PROCESS_DEFINITION_KEY);
        // 新增的时候procUnitId一定要设置成Apply，不然jsp页面的所有表单元素是readonly状态
        this.putAttribute("procUnitId", "Apply");
        NonOrderStorage nonOrderStorage = new NonOrderStorage();
        nonOrderStorage.setStatusId(BizBillStatus.APPLYING.getId());
        /**
         * 设置jsp页面初始化填充数据，如果不设置， 那么在jsp页面上填写完表单之后立即提交申请TaskDescription获取不到时间和相关人员信息
         */
        Operator operator = getOperator();
        nonOrderStorage.setDefaultValues(new OrgUnit(operator.getFullId(), operator.getFullName()));
        return forward("nonOrderStorageDetail", nonOrderStorage);
    }

    /**
     * 根据id获取
     * @return
     */
    public String showNonOrderStorageDetail() {
        SDO sdo = this.getSDO();
        String id = sdo.getBizId();
        NonOrderStorage nonOrderStorage = nonOrderStorageApplication.findNonOrderStorageById(id);
        return forward("nonOrderStorageDetail", nonOrderStorage);
    }

    /**
     * 根据id删除
     * @return
     */
    public String deleteNonOrderStorageById() {
        SDO sdo = this.getSDO();
        List<String> ids = sdo.getIds();
        nonOrderStorageApplication.deleteNonOrderStorageById(ids);
        return success();

    }
}
