package com.huigou.topsun.sap.finaCustomer.controller;

import com.huigou.context.Operator;
import com.huigou.context.OrgUnit;
import com.huigou.topsun.sap.finaCustomer.application.FinaCustomerApplication;
import com.huigou.topsun.sap.finaCustomer.domain.FinaCustomerInfo;
import com.huigou.topsun.sap.finaCustomer.domain.query.FinaCustomerQueryRequest;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.bmp.common.BizBillStatus;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import com.huigou.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Auther: LXH
 *
 * @Date: 2024/03/01
 * @Description:
 */
@Controller
@ControllerMapping("/finaCustomer")
public class FinaCustomerController extends CommonController {

    protected String getPagePath() {
        return "/biz/topsun/sap/finaCustomer/";
    }


    @Autowired
    FinaCustomerApplication finaCustomerApplication;


    public String forwardFinaCustomerList() {
        return forward("finaCustomerList");
    }


    public String slicedFinaCustomerList() {
        SDO sdo = this.getSDO();
        FinaCustomerQueryRequest queryRequest = sdo.toQueryRequest(FinaCustomerQueryRequest.class);
        Map<String, Object> map = finaCustomerApplication.slicedFinaCustomerQuery(queryRequest);
        return toResult(map);
    }


    public String forwardFinaCustomerApply() {

       this.putAttribute("processDefinitionKey",FinaCustomerApplication.PROCESS_DEFINITION_KEY);
       this.putAttribute("procUnitId","Apply");//定义流程环节的id
       this.putAttribute("applyType","0");
        SDO sdo = this.getSDO();
        String bizId=sdo.getString("bizId");
        String flag=sdo.getString("flag");
        FinaCustomerInfo finaCustomerInfo = new FinaCustomerInfo();
        finaCustomerInfo.setCreationGroup("C006");//分组：	默认【C006】，不可更改
        finaCustomerInfo.setPartnerRole("FLCUOO");//业务伙伴角色 默认【FLCUOO】
        finaCustomerInfo.setApplyType("0");
        String isDel=sdo.getString("isDel");
        String page = "finaCustomerDetail";
        if (StringUtil.isNotBlank(isDel)){ //删除流程
            finaCustomerInfo = finaCustomerApplication.loadFinaCustomerById(bizId);
            this.putAttribute("processDefinitionKey", FinaCustomerApplication.PROCESS_DEFINITION_KEY3);
            this.putAttribute("applyType", "-1");
            finaCustomerInfo.setApplyType("-1");
            finaCustomerInfo.setBillCode("");
            finaCustomerInfo.setId("");
            // finaCustomerInfo.setSId(bizId);
            Map<String, Object> map = new HashMap();
            map.put("bizId", "");
            sdo.setProperties(map);
            finaCustomerInfo.setFullId("");
            this.putAttribute("bizId", "");
            this.putAttribute("sId", bizId);
            this.putAttribute("id", "");
        } else {
            if (StringUtil.isNotBlank(bizId)) {
                finaCustomerInfo = finaCustomerApplication.loadFinaCustomerById(bizId);

                sdo.putProperty("buPartner",finaCustomerInfo.getBuPartner());
                List deletedList=finaCustomerApplication.findDeletedFinaCustomerById(sdo);

                if (deletedList.size()>0){
                    throw new RuntimeException("该财务客户已经执行删除，不能再次修改了！");
                }
                if ("update".equals(flag)){
                    this.putAttribute("processDefinitionKey", FinaCustomerApplication.PROCESS_DEFINITION_KEY2);
                    this.putAttribute("applyType", "1");
                    finaCustomerInfo.setApplyType("1");
                } else if ("extend".equals(flag)) {
                    this.putAttribute("processDefinitionKey", FinaCustomerApplication.PROCESS_DEFINITION_KEY4);
                    this.putAttribute("applyType", "2");//扩展
                    finaCustomerInfo.setApplyType("2");
                    page = "finaCustomerExtendDetail";
                }

                finaCustomerInfo.setBillCode("");
                finaCustomerInfo.setId("");
                // finaCustomerInfo.setSId(bizId);
                Map<String, Object> map = new HashMap();
                map.put("bizId", "");
                sdo.setProperties(map);
                finaCustomerInfo.setFullId("");
                this.putAttribute("bizId", "");
                this.putAttribute("sId", bizId);
                this.putAttribute("id", "");
            }
        }
        finaCustomerInfo.setStatusId(BizBillStatus.APPLYING.getId());
        Operator operator = getOperator();//获取当前操作员的详情信息
        finaCustomerInfo.setDefaultValues(new OrgUnit(operator.getFullId(),operator.getFullName()));

        return  forward(page,finaCustomerInfo);
   }

    public String showFinaCustomer() {
        SDO sdo = this.getSDO();
        String id = sdo.getBizId();
        String isDetailPage = sdo.getString("isDetailPage");
        this.putAttribute("applyType","0");
        if("true".equals(isDetailPage)) this.putAttribute("isDetailPage","true");
        FinaCustomerInfo finaCustomerInfo = finaCustomerApplication.loadFinaCustomerById(id);
        if (!(finaCustomerInfo.getApplyType().equals("0"))){
            this.putAttribute("sId", id);
            this.putAttribute("applyType",finaCustomerInfo.getApplyType());
            if ("2".equals(finaCustomerInfo.getApplyType())){
                return forward("finaCustomerExtendDetail", finaCustomerInfo);
            }
        }
        return forward("finaCustomerDetail", finaCustomerInfo);
    }

    public String  slicedFinaCustomerPayData(){
        SDO sdo = this.getSDO();
        FinaCustomerQueryRequest queryRequest=sdo.toQueryRequest(FinaCustomerQueryRequest.class);
        queryRequest.setSId(sdo.getString("sId"));
        Map<String, Object> map = finaCustomerApplication.loadFinaCustomerPayDatas(queryRequest);
        return toResult(map);
     }

    public String  slicedFinaCustomerBankData(){
        SDO sdo = this.getSDO();
        FinaCustomerQueryRequest queryRequest=sdo.toQueryRequest(FinaCustomerQueryRequest.class);
        queryRequest.setSId(sdo.getString("sId"));
        Map<String, Object> map = finaCustomerApplication.loadFinaCustomerBankDatas(queryRequest);
        return toResult(map);
    }

    public String deleteFinaCustomerPays() {
        SDO sdo = this.getSDO();
        List<String> ids = sdo.getIds();
        finaCustomerApplication.deleteFinaCustomerPaysByIds(ids);
        return success();
    }

    public String deleteFinaCustomerBanks() {
        SDO sdo = this.getSDO();
        List<String> ids = sdo.getIds();
        finaCustomerApplication.deleteFinaCustomerBankByIds(ids);
        return success();
    }

    public String checkApprovalStatus(){
        SDO sdo = this.getSDO();
        String partner = sdo.getString("partner");
        finaCustomerApplication.checkApprovalStatus(partner);
        return success();
    }

    public String getFinaCustomerNowItemList(){
        SDO sdo = this.getSDO();
        String buPartner = sdo.getString("buPartner");
        Map<String, String> map = finaCustomerApplication.getFinaCustomerNowItemList(buPartner);
        return toResult(map);
    }
}
