package com.huigou.topsun.sap.exceptionReport.domain;

import com.huigou.data.domain.model.AbstractEntity;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Auther: lxh
 * @Date: 2024/08/21/15:05
 * @Description: 品质异常报告供应商 商品赔付处理方式
 */
@Data
@Entity
@Table(name = "sap_exception_report_goods")
public class ExceptionReportGoods extends AbstractEntity {

    /**
     * 品质异常报告id
     */
    @Column(name = "exception_report_id")
    private String exceptionReportId;

    /**
     * 公司
     */
    @Column(name = "company")
    private String company;

    @Column(name = "company_name")
    private String companyName;


    //采购组织
    @Column(name = "purchase_team")
    private String purchaseTeam;

    @Column(name = "purchase_team_name")
    private String purchaseTeamName;

    @Column(name = "ekgrp")
    private String ekgrp;
    /**
     * 产品/原材料编码
     */
    @Column(name = "product_code")
    private String productCode;

    /**
     * 产品/原材料名称
     */
    @Column(name = "product_name")
    private String productName;

    /**
     * 单位
     */
    @Column(name = "unit")
    private String unit;

    /**
     * 单位描述
     */
    @Column(name = "unit_name")
    private String unitName;

    /**
     * 币别
     */
    @Column(name = "currency")
    private String currency;

    /**
     * 币别描述
     */
    @Column(name = "currency_name")
    private String currencyName;

   /**
     * 数量
     */
    @Column(name = "number")
    private BigDecimal number;

    /**
     * 金额
     */
    @Column(name = "money")
    private BigDecimal money;

   
    /**
     * 需求日期
     */
    @Column(name = "need_date")
    private Date needDate;

    /*
     *收货工厂
     */
    @Column(name = "werks_name")
    private String werksName;


    @Column(name = "werks")
    private String werks;
    /*
     *收货地点
     */
    @Column(name = "location")
    private String location;

    /*
     *收货地点
     */
    @Column(name = "location_name")
    private String locationName;
    /*
     *备注
     */
    @Column(name = "remark")
    private String remark;
}
