package com.huigou.topsun.sap.exceptionReport.controller;

import com.huigou.cache.DictUtil;
import com.huigou.context.Operator;
import com.huigou.context.OrgUnit;
import com.huigou.topsun.common.BillStatus;
import com.huigou.topsun.sap.exceptionReport.application.*;
import com.huigou.topsun.sap.exceptionReport.domain.ExceptionReport;
import com.huigou.topsun.sap.exceptionReport.domain.ExceptionReportResponsible;
import com.huigou.topsun.sap.exceptionReport.domain.query.ExceptionReportQueryRequest;
import com.huigou.topsun.sap.sapApplication.application.SapMaterialApplication;
import com.huigou.topsun.sap.sapApplication.domain.query.SapDialogOrderQuery;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.bmp.common.BizBillStatus;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.CommonUtil;
import com.huigou.util.SDO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.ObjectUtils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Auther: xin.lu
 * @Date: 2024/03/20/19:37
 * @Description:
 */
@Controller
@ControllerMapping("/exceptionReport")
public class ExceptionReportController extends CommonController {
    @Autowired
    private ExceptionReportApplication exceptionReportApplication;
    @Autowired
    private ExceptionReportItemApplication exceptionReportItemApplication;
    @Autowired
    private ExceptionReportDutyPersonApplication exceptionReportDutyPersonApplication;

    @Autowired
    private ExceptionReportPayableApplication exceptionReportPayableApplication;
    @Autowired
    private ExceptionReportCashApplication exceptionReportCashApplication;
    @Autowired
    private ExceptionReportGoodsApplication exceptionReportGoodsApplication;
    @Autowired
    private SapMaterialApplication sapMaterialApplication;

    @Override
    protected String getPagePath() {
        return "/biz/topsun/sap/exceptionReport/";
    }

    /**
     * 跳转到品质异常报告查询页面
     * @return
     */
    public String forwardExceptionReportList(){
        this.putAttribute("statusKindsList", BillStatus.getValidMap());
        this.putAttribute("needImproveReportList", DictUtil.getDictionary("yesorno"));
        this.putAttribute("needGuaranteeList", DictUtil.getDictionary("yesorno"));
        return forward("exceptionReportList");
    }

    /**
     * 条件查询品质异常报告
     * @return
     */
    public String slicedExceptionReportList(){
        SDO sdo = this.getSDO();
        ExceptionReportQueryRequest queryRequest = sdo.toQueryRequest(ExceptionReportQueryRequest.class);
        Map<String, Object> map = new HashMap<>();
        if (ObjectUtils.isEmpty(sdo.getProperty("exportHead"))) {
            map = exceptionReportApplication.slicedExceptionReportList(queryRequest);
        }else {
            map = exceptionReportApplication.slicedExceptionReportExportList(queryRequest);
        }
        return toResult(map);
    }

    public String chooseExceptionClientDetail(){
        SDO sdo = this.getSDO();
        String customerOrderNo = sdo.getString("customerOrderNo");
        this.putAttribute("customerOrderNo",customerOrderNo);
        return forward("chooseExceptionClientDetail");
    }

    /**
     * 跳转到新增品质异常报告页面
     * @return
     */
    public String addExceptionReportDetail(){
        this.putAttribute("processDefinitionKey", ExceptionReportApplication.PROCESS_DEFINITION_KEY);
        // 新增的时候procUnitId一定要设置成Apply，不然jsp页面的所有表单元素是readonly状态
        this.putAttribute("procUnitId", "Apply");
        ExceptionReport exceptionReport = new ExceptionReport();
        exceptionReport.setStatusId(BizBillStatus.APPLYING.getId());
        exceptionReport.setAttbizId(CommonUtil.createGUID()); // 自动生成附件id
        SDO sdo = this.getSDO();
        String  billType=sdo.getString("billType");
        this.putAttribute("billType",billType);

        List<Map<String,Object>> list= exceptionReportApplication.getCustomerOrders("");
        Map  map=new HashMap();
        map.put("alert-success", "绿色");
        map.put("alert-info", "蓝色");
        map.put("alert-warning", "黄色");
        map.put("alert-danger", "红色");
        this.putAttribute("customerOrders",map);
        /**
         * 设置jsp页面初始化填充数据，如果不设置， 那么在jsp页面上填写完表单之后立即提交申请TaskDescription获取不到时间和相关人员信息
         */
        Operator operator = getOperator();
        exceptionReport.setDefaultValues(new OrgUnit(operator.getFullId(), operator.getFullName()));
        exceptionReport.setBillType(billType);
        if  ("purchase".equals(billType)||"outgoing".equals(billType)) {
            return forward("exceptionReportDetailPurchase", exceptionReport);
        } else if  ("supplier".equals(billType)) {
            return forward("exceptionReportDetailSupplier", exceptionReport);
        } else {
            return forward("exceptionReportDetail", exceptionReport);
        }
    }



    /**
     * 跳转到品质异常报告详情页面
     * @return
     */
    public String showExceptionReportDetail(){
        SDO sdo = this.getSDO();
        String id = sdo.getBizId();
        ExceptionReport exceptionReport = exceptionReportApplication.findById(id);

        if ("produce".equals(exceptionReport.getBillType())||"outgoing".equals(exceptionReport.getBillType())) {
            exceptionReport.setCustomerNoPur(exceptionReport.getCustomerOrderNo());
            exceptionReport.setCustomerNamePur(exceptionReport.getCustomerName());
            exceptionReport.setCustomerOrderNoPur(exceptionReport.getCustomerOrderNo());
            return forward("exceptionReportDetail", exceptionReport);
        } else if ("supplier".equals(exceptionReport.getBillType())){
            return forward("exceptionReportDetailSupplier", exceptionReport);
        } else {
            return forward("exceptionReportDetail", exceptionReport);
        }
    }
     //获取责任人变更次数
    public String getResponsibleTimes() {
        SDO sdo = this.getSDO();
        String id = sdo.getString("id");
        return  this.exceptionReportApplication.getResponsibleTimes(id);
    }
    /**
     * 删除品质异常报告
     * @return
     */
    public String deleteExceptionReport(){
        SDO sdo = this.getSDO();
        List<String> ids = sdo.getIds();
        for (String id : ids) {
            exceptionReportApplication.deleteById(id);
        }
        return success();
    }

    /**
     * 条件查询品质异常报告明细
     * @return
     */
    public String slicedExceptionReportItemList(){
        SDO sdo = this.getSDO();
        ExceptionReportQueryRequest queryRequest = sdo.toQueryRequest(ExceptionReportQueryRequest.class);
        return toResult(exceptionReportItemApplication.slicedExceptionReportItemList(queryRequest));
    }

    /**
     * 删除品质异常报告明细
     * @return
     */
    public String deleteExceptionReportItem(){
        SDO sdo = this.getSDO();
        List<String> ids = sdo.getIds();
        exceptionReportItemApplication.deleteByIds(ids);
        return success();
    }

    /**
     * 条件查询品质异常报告责任人
     * @return
     */
    public String slicedExceptionReportDutyPersonList(){
        SDO sdo = this.getSDO();
        ExceptionReportQueryRequest queryRequest = sdo.toQueryRequest(ExceptionReportQueryRequest.class);
        return toResult(exceptionReportDutyPersonApplication.slicedExceptionReportDutyPersonList(queryRequest));
    }

    /**
     * 删除品质异常报告责任人
     * @return
     */
    public String deleteExceptionReportDutyPerson(){
        SDO sdo = this.getSDO();
        List<String> ids = sdo.getIds();
        exceptionReportDutyPersonApplication.deleteByIds(ids);
        return success();
    }

    /**
     * 查询品质异常报告扣除应付款处理方式
     * @return
     */
    public String slicedExceptionReportPayableList(){
        SDO sdo = this.getSDO();
        ExceptionReportQueryRequest queryRequest = sdo.toQueryRequest(ExceptionReportQueryRequest.class);
        return toResult(exceptionReportPayableApplication.slicedExceptionReportPayableList(queryRequest));
    }

    /**
     * 删除品质异常报告扣除应付款处理方式
     * @return
     */
    public String deleteExceptionReportPayable(){
        SDO sdo = this.getSDO();
        List<String> ids = sdo.getIds();
        exceptionReportPayableApplication.deleteByIds(ids);
        return success();
    }

    /**
     * 查询品质异常报告现金处理方式
     * @return
     */
    public String slicedExceptionReportCashList(){
        SDO sdo = this.getSDO();
        ExceptionReportQueryRequest queryRequest = sdo.toQueryRequest(ExceptionReportQueryRequest.class);
        return toResult(exceptionReportCashApplication.slicedExceptionReportCashList(queryRequest));
    }

    /**
     * 删除品质异常报告现金处理方式
     * @return
     */
    public String deleteExceptionReportCash(){
        SDO sdo = this.getSDO();
        List<String> ids = sdo.getIds();
        exceptionReportCashApplication.deleteByIds(ids);
        return success();
    }
    /**
     * 查询品质异常报告商品赔付处理方式
     * @return
     */
    public String slicedExceptionReportGoodsList(){
        SDO sdo = this.getSDO();
        ExceptionReportQueryRequest queryRequest = sdo.toQueryRequest(ExceptionReportQueryRequest.class);
        return toResult(exceptionReportGoodsApplication.slicedExceptionReportGoodsList(queryRequest));
    }

    /**
     * 删除品质异常报告商品赔付处理方式
     * @return
     */
    public String deleteExceptionReportGoods(){
        SDO sdo = this.getSDO();
        List<String> ids = sdo.getIds();
        exceptionReportGoodsApplication.deleteByIds(ids);
        return success();
    }

    public String getCustomerOrders(){
        SDO sdo = this.getSDO();
        List<String> ids = sdo.getIds();
        List<Map<String,Object>> list= exceptionReportApplication.getCustomerOrders(sdo.getString("customerNo"));
        this.putAttribute("customerOrders",list);
        return success();
    }

    public String slicedExceptionClientList(){
        SDO sdo = this.getSDO();
        SapDialogOrderQuery queryRequest = sdo.toObject(SapDialogOrderQuery.class);
        List<Map<String,String>> mapList = new ArrayList<>();
        try {
            mapList = sapMaterialApplication.getSapCustomerOrder(queryRequest);
        } catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
        return packGridDataAndResult(mapList);
    }
}
