package com.huigou.topsun.sap.customerDelayPay.controller;

import com.huigou.context.Operator;
import com.huigou.context.OrgUnit;
import com.huigou.topsun.sap.customerDelayPay.application.CustomerDelayPayApplication;
import com.huigou.topsun.sap.customerDelayPay.application.CustomerDelayPayItemApplication;
import com.huigou.topsun.sap.customerDelayPay.domain.CustomerDelayPay;
import com.huigou.topsun.sap.customerDelayPay.domain.CustomerDelayPayItem;
import com.huigou.topsun.sap.customerDelayPay.domain.query.CustomerDelayPayQueryRequest;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.bmp.common.BizBillStatus;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import java.util.List;
import java.util.Map;

/**
 * @Auther: xin.lu
 * @Date: 2024/04/13/14:51
 * @Description:
 */
@Controller
@ControllerMapping("/customerDelayPay")
public class CustomerDelayPayController extends CommonController {
    @Override
    protected String getPagePath() {
        return "/biz/topsun/sap/customerDelayPay/";
    }

    @Autowired
    private CustomerDelayPayApplication customerDelayPayApplication;
    @Autowired
    private CustomerDelayPayItemApplication customerDelayPayItemApplication;
    public String forwardCustomerDelayPayList(){
        return forward("customerDelayPayList");
    }

    public String slicedCustomerDelayPayList(){
        SDO sdo = this.getSDO();
        CustomerDelayPayQueryRequest queryRequest = sdo.toQueryRequest(CustomerDelayPayQueryRequest.class);
        Map<String, Object> map = customerDelayPayApplication.slicedCustomerDelayPayList(queryRequest);
        return toResult(map);
    }

    public String forwardCustomerDelayPayDetail(){
        this.putAttribute("processDefinitionKey", CustomerDelayPayApplication.PROCESS_DEFINITION_KEY);
        // 新增的时候procUnitId一定要设置成Apply，不然jsp页面的所有表单元素是readonly状态
        this.putAttribute("procUnitId", "Apply");
        CustomerDelayPay customerDelayPay = new CustomerDelayPay();
        customerDelayPay.setStatusId(BizBillStatus.APPLYING.getId());
        /**
         * 设置jsp页面初始化填充数据，如果不设置， 那么在jsp页面上填写完表单之后立即提交申请TaskDescription获取不到时间和相关人员信息
         */
        Operator operator = getOperator();
        customerDelayPay.setDefaultValues(new OrgUnit(operator.getFullId(), operator.getFullName()));
        return forward("customerDelayPayDetail",customerDelayPay);
    }

    public String showCustomerDelayPayDetail(){
        SDO sdo = this.getSDO();
        String id = sdo.getBizId();
        CustomerDelayPay customerDelayPay = customerDelayPayApplication.findCustomerDelayPayById(id);
        return forward("customerDelayPayDetail",customerDelayPay);
    }

    public String queryCustomerDelayPayItems(){
        SDO sdo = this.getSDO();
        CustomerDelayPayQueryRequest queryRequest = sdo.toQueryRequest(CustomerDelayPayQueryRequest.class);
        Map<String,Object> map = customerDelayPayItemApplication.queryCustomerDelayPayItems(queryRequest);
        return toResult(map);
    }

    public String deleteCustomerDelayPayItem(){
        SDO sdo = this.getSDO();
        List<String> ids = sdo.getIds();
        customerDelayPayItemApplication.deleteByIds(ids);
        return success();
    }
}
