package com.huigou.topsun.mes.produceException.controller;

import com.huigou.context.Operator;
import com.huigou.context.OrgUnit;
import com.huigou.topsun.mes.produceException.application.ProduceExceptionApplication;
import com.huigou.topsun.mes.produceException.domain.ProduceException;
import com.huigou.topsun.mes.produceException.domain.query.ProduceExceptionQueryRequest;
import com.huigou.topsun.mes.produceException.domain.vo.ProduceExceptionVo;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.annotation.SkipAuth;
import com.huigou.uasp.bmp.common.BizBillStatus;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.JSONUtil;
import com.huigou.util.SDO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.HashMap;
import java.util.Map;

/**
 * @Auther: xin.lu
 * @Date: 2024/08/12/10:30
 * @Description:
 */
@Controller
@ControllerMapping("/produceException")
public class ProduceExceptionController extends CommonController {
    private final static Logger LOG = LoggerFactory.getLogger(ProduceExceptionController.class);
    @Autowired
    private ProduceExceptionApplication produceExceptionApplication;
    @Override
    protected String getPagePath() {
        return "/biz/topsun/mes/produceException/";
    }

    public String forwardProduceExceptionList(){
        return forward("produceExceptionList");
    }

    @SkipAuth
    @RequestMapping( value = "/getMesProduceException")
    @ResponseBody
    public HashMap<String, Object> getMesProduceException(@RequestBody ProduceExceptionVo produceExceptionVo){
        //SDO sdo = this.getSDO();
        HashMap<String, Object> messageMap = new HashMap<>();
        messageMap.put("Message_Status","S");
        messageMap.put("Message_Text","成功");
        LOG.info("MES异常审批数据=={}", JSONUtil.toString(produceExceptionVo));
        try {
            this.produceExceptionApplication.saveMesProduceExceptionVo(produceExceptionVo);
        }catch (RuntimeException e){
            messageMap.put("Message_Status","E");
            messageMap.put("Message_Text",e.getMessage());
        }finally {
            LOG.info("MES异常返回数据=={}", JSONUtil.toString(messageMap));
        }
        return messageMap;
    }

    public String slicedProduceExceptionList(){
        SDO sdo = this.getSDO();
        ProduceExceptionQueryRequest queryRequest = sdo.toQueryRequest(ProduceExceptionQueryRequest.class);
        Map<String, Object> map = produceExceptionApplication.slicedProduceExceptionList(queryRequest);
        return toResult(map);
    }

    public String forwardProduceExceptionDetail(){
        this.putAttribute("processDefinitionKey", ProduceExceptionApplication.PROCESS_DEFINITION_KEY);
        // 新增的时候procUnitId一定要设置成Apply，不然jsp页面的所有表单元素是readonly状态
        this.putAttribute("procUnitId", "Apply");
        ProduceException produceException = new ProduceException();
        produceException.setStatusId(BizBillStatus.APPLYING.getId());
        /**
         * 设置jsp页面初始化填充数据，如果不设置， 那么在jsp页面上填写完表单之后立即提交申请TaskDescription获取不到时间和相关人员信息
         */
        Operator operator = getOperator();
        produceException.setDefaultValues(new OrgUnit(operator.getFullId(), operator.getFullName()));
        return forward("produceExceptionDetail",produceException);
    }

    public String showProduceExceptionDetail(){
        SDO sdo = this.getSDO();
        String id = sdo.getBizId();
        ProduceException produceException = produceExceptionApplication.findProduceExceptionById(id);
        return forward("produceExceptionDetail",produceException);
    }

    public String uploadFile(){
        SDO sdo = this.getSDO();
        String id = sdo.getId();
        this.putAttribute("bizId",id);
        return forward("attachment");
    }

}
