package com.huigou.topsun.ep.order.domain.vo;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @Auther: xin.lu
 * @Date: 2024/03/12/17:21
 * @Description: EP销售订单明细
 */
@Data
public class EpSaleOrderItemVo implements Serializable {
    /**
     * EP销售订单id
     */
    private String epSaleOrderId;

    /**
     * 订单原因（业务交易原因）
     */
    @JsonProperty("augru")
    private String augru;

    /**
     * 订单编号
     */
    @JsonProperty("vbeln")
    private String vbeln;

    /**
     * 订单总金额
     */
    @JsonProperty("netwr")
    private BigDecimal netwr;

    @JsonProperty("amount")
    private BigDecimal amount;

    /**
     * 客户采购单号
     */
    @JsonProperty("bstnk")
    private String bstnk;

    /**
     * 销售凭证项目
     */
    @JsonProperty("posnr")
    private String posnr;

    /**
     * 物料编号
     */
    @JsonProperty("matnr")
    private String matnr;

    /**
     * 物料描述
     */
    @JsonProperty("maktx")
    private String maktx;

    /**
     * 订单数量
     */
    @JsonProperty("kwmeng")
    private BigDecimal kwmeng;

    /**
     * 销售单位
     */
    @JsonProperty("vrkme")
    private String vrkme;

    /**
     * 价格
     */
    @JsonProperty("vaKbetr")
    private BigDecimal vaKbetr;

    /**
     * 工厂
     */
    @JsonProperty("werks")
    private String werks;

    /**
     * 指令号
     */
    @JsonProperty("zinstnum")
    private String zinstnum;

    /**
     * 型体号
     */
    @JsonProperty("zmold")
    private String zmold;

    /**
     * 配色号
     */
    @JsonProperty("zmapcolor")
    private String zmapcolor;

    /**
     * 品牌
     */
    @JsonProperty("mvgr1")
    private String mvgr1;

    /**
     * 物料组
     */
    @JsonProperty("matkl")
    private String matkl;

    /**
     * 跟单员
     */
    @JsonProperty("merchandiser")
    private String merchandiser;

    /**
     * 生产工单
     */
    @JsonProperty("workorderCode")
    private String workorderCode;
}
