package com.huigou.topsun.ep.order.domain;

import com.huigou.data.domain.model.FlowBillAbstractEntity;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * @Auther: xin.lu
 * @Date: 2024/03/12/17:16
 * @Description: EP销售订单
 */
@Data
@Entity
@Table(name = "ep_sale_order")
public class EpSaleOrder extends FlowBillAbstractEntity {
    /**
     * 订单类型
     */
    @Column(name = "order_type")
    private String orderType;

    /**
     * 订单类型描述
     */
    @Column(name = "order_type_name")
    private String orderTypeName;

    /**
     * 联系电话长号
     */
    @Column(name = "tel_phone_long")
    private String telPhoneLong;

    /**
     * 联系电话短号
     */
    @Column(name = "tel_phone_short")
    private String telPhoneShort;

    /**
     * 联系人
     */
    @Column(name = "contact")
    private String contact;

    /**
     * 售达方
     */
    @Column(name = "KUNNR")
    private String kunnr;

    @Column(name = "code")
    private String code;

    @Column(name = "msg")
    private String msg;

    /**
     * 跟单员
     */
    @Column(name = "merchandiser")
    private String merchandiser;

    // 退货原因
    @Column(name = "return_reason")
    private String returnReason;

    // 责任部门
    @Column(name = "duty_dept")
    private String dutyDept;

    // 责任人
    @Column(name = "duty_by")
    private String dutyBy;

    // 后续处理意见
    @Column(name = "return_opinion")
    private String returnOpinion;

    // 其他备注
    @Column(name = "return_remark")
    private String returnRemark;

    // 退货地址
    @Column(name = "return_address")
    private String returnAddress;


    @Override
    protected String getCodeRuleId() {
        return "epSaleOrder";
    }
}
