package com.huigou.topsun.ep.epApplication.impl;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.huigou.topsun.ep.epApplication.EpApplication;
import com.huigou.topsun.ep.epApplication.EpVo.EpProductInfoVo;
import com.huigou.topsun.sap.common.HttpClient;
import com.huigou.topsun.sap.common.domain.EpResult;
import com.huigou.topsun.sap.common.domain.EpResultValue;
import com.huigou.topsun.util.SAPUtils;
import com.huigou.util.ClassHelper;
import com.sun.org.apache.regexp.internal.RE;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.*;

/**
 * @Auther: xin.lu
 * @Date: 2024/06/22/15:23
 * @Description:
 */
@Service("epApplication")
public class EpApplicationImpl implements EpApplication {
    @Autowired
    private HttpClient httpClient;
    @Override
    public List<Map<String, String>> queryEpBrand(String brandName) {
        Map<String,Object> map = new HashMap<>();
        map.put("brandName",brandName);
        List<Map<String, String>> mapList = new ArrayList<>();
        String message = "";
        try {
            String executeForEp = httpClient.executeForEp(map, "md/brand/queryAllEnableBrand");
            Map<String, Object> resultMap = JSONObject.parseObject(executeForEp, Map.class);
            if ("200".equals(resultMap.get("code").toString())) {
                ObjectMapper objectMapper = SAPUtils.objectMapper();
                mapList = objectMapper.readValue(com.huigou.util.JSONUtil.toString(resultMap.get("data")), new TypeReference<List<Map<String, String>>>() {});
            }else {
                message = (String) resultMap.get("msg");
            }
        } catch (IOException e) {
            throw new RuntimeException("查询品牌出错：" + message);
        }
        return mapList;
    }

    @Override
    public List<Map<String, String>> queryEpPd(String brandCode) {
        Map<String,Object> map = new HashMap<>();
        //map.put("brandCode",brandCode);
        List<Map<String, String>> mapList = new ArrayList<>();
        String message = "";
        try {
            String executeForEp = httpClient.executeForEp(map, "md/mdItem/queryProductByBrandCode?brandCode="+brandCode);
            Map<String, Object> resultMap = JSONObject.parseObject(executeForEp, Map.class);
            if ("200".equals(resultMap.get("code").toString())) {
                ObjectMapper objectMapper = SAPUtils.objectMapper();
                mapList = objectMapper.readValue(com.huigou.util.JSONUtil.toString(resultMap.get("data")), new TypeReference<List<Map<String, String>>>() {});
            }else {
                message =(String) resultMap.get("msg");
            }
        } catch (IOException e) {
            throw new RuntimeException("查询产品出错：" + message);
        }
        return mapList;
    }

    @Override
    public List<Map<String, String>> queryProductAndBom(String itemCode) {
        Map<String,Object> map = new HashMap<>();
        //map.put("brandCode",brandCode);
        List<Map<String, String>> mapList = new ArrayList<>();
        String message = "";
        try {
            String executeForEp = httpClient.executeForEp(map, "md/mdItem/queryProductAndBomByItemCode?itemCode="+itemCode);
            Map<String, Object> resultMap = JSONObject.parseObject(executeForEp, Map.class);
            if ("200".equals(resultMap.get("code").toString())) {
                ObjectMapper objectMapper = SAPUtils.objectMapper();
                mapList = objectMapper.readValue(com.huigou.util.JSONUtil.toString(resultMap.get("data")), new TypeReference<List<Map<String, String>>>() {});
            }else {
                message =(String) resultMap.get("msg");
            }
        } catch (IOException e) {
            throw new RuntimeException("查询制程工艺、原材料出错：" + message);
        }
        return mapList;
    }

    @Override
    public EpProductInfoVo queryEpProductInfo(String matnr2) {
        String message = "";
        EpProductInfoVo epProductInfoVo = new EpProductInfoVo();
        try {
            ///api/pro/productionSolution/getPicture?groupCounter=02&groupKey=50000407
            String executeForEp = httpClient.executeForEp(new HashMap<>(), "md/mdItem/getUrl?sapItemCode="+matnr2);
            Map<String, Object> resultMap = JSONObject.parseObject(executeForEp, Map.class);
            if ("200".equals(resultMap.get("code").toString())) {
                ObjectMapper objectMapper = SAPUtils.objectMapper();
                epProductInfoVo = objectMapper.readValue(com.huigou.util.JSONUtil.toString(resultMap.get("data")), new TypeReference<EpProductInfoVo>() {});
            }else {
                message =(String) resultMap.get("msg");
            }
        } catch (IOException e) {
            throw new RuntimeException("查询生产版本正反面图片出错：" + message);
        }
        epProductInfoVo.setMatnr(matnr2.replaceFirst("^0*", ""));
        return epProductInfoVo;
    }

    @Override
    public List<Map<String, String>> queryEpProductProcess(String itemCode) {
        Map<String,Object> map = new HashMap<>();
        List<Map<String, String>> mapList = new ArrayList<>();
        String message = "";
        try {
            //md/mdItem/queryBrandByItemCode/{itemCode}
            String executeForEp = httpClient.executeForEp(map, "md/mdItem/queryProcessByItemCode/"+itemCode);
            Map<String, Object> resultMap = JSONObject.parseObject(executeForEp, Map.class);
            if ("200".equals(resultMap.get("code").toString())) {
                ObjectMapper objectMapper = SAPUtils.objectMapper();
                mapList = objectMapper.readValue(com.huigou.util.JSONUtil.toString(resultMap.get("data")), new TypeReference<List<Map<String, String>>>() {});
            }else {
                message =(String) resultMap.get("msg");
            }
        } catch (IOException e) {
            throw new RuntimeException("查询工序出错：" + e.getMessage());
        }
        return mapList;
    }

    @Override
    public List<Map<String, String>> queryEpBrandByItemCode(String itemCode) {
        String url = "md/mdItem/queryBrandByItemCode/" + itemCode;
        List<Map<String, String>> mapList = new ArrayList<>();
            Map map = new HashMap();
            try {
                String result = httpClient.executeForEp(map, url);
                EpResult epResult = JSONObject.parseObject(result, EpResult.class);
                if ("200".equals(epResult.getCode())) {
                    if (epResult.getData()!=null){
                        EpResultValue data = epResult.getData();
                        Map<String,String> resultMap = new HashMap<>();
                        resultMap.put("code",data.getCode());
                        resultMap.put("name",data.getName());
                        mapList.add(resultMap);
                    }
                } else {
                    throw new RuntimeException("从EP查询品牌错误:" + epResult.getMsg());
                }
            } catch (IOException e) {
                throw new RuntimeException("EP服务器无响应请稍后手动重试！error:" + e.getMessage());
            }
            return mapList;
        }

    @Override
    public List<Map<String, String>> queryEpProofingProduct() {
        Map<String,Object> map = new HashMap<>();
        List<Map<String, String>> mapList = new ArrayList<>();
        String message = "";
        try {
            String executeForEp = httpClient.executeHttpGetForEp(map, "pro/listPrototypeMake");
            Map<String, Object> resultMap = JSONObject.parseObject(executeForEp, Map.class);
            if ("200".equals(resultMap.get("code").toString())) {
                ObjectMapper objectMapper = SAPUtils.objectMapper();
                mapList = objectMapper.readValue(com.huigou.util.JSONUtil.toString(resultMap.get("data")), new TypeReference<List<Map<String, String>>>() {});
            }else {
                message =(String) resultMap.get("msg");
                throw new RuntimeException("查询EP打样产品信息出错:" + message);
            }
        } catch (IOException e) {
            throw new RuntimeException("查询EP打样产品信息出错：" + e.getMessage());
        }
        return mapList;
    }

    @Override
    public List<Map<String,String>> queryEpProductProcessByProofingNo(String proofingNo) {
        Map<String,Object> map = new HashMap<>();
        List<Map<String, String>> mapList = new ArrayList<>();
        String message = "";
        try {
            //md/mdItem/queryBrandByItemCode/{itemCode}
            String executeForEp = httpClient.executeHttpGetForEp(map, "pro/listProcessByPrototypeMakeCode?prototypeMakeCode="+proofingNo);
            Map<String, Object> resultMap = JSONObject.parseObject(executeForEp, Map.class);
            if ("200".equals(resultMap.get("code").toString())) {
                ObjectMapper objectMapper = SAPUtils.objectMapper();
                mapList = objectMapper.readValue(com.huigou.util.JSONUtil.toString(resultMap.get("data")), new TypeReference<List<Map<String, String>>>() {});
            }else {
                message =(String) resultMap.get("msg");
            }
        } catch (IOException e) {
            throw new RuntimeException("查询工序出错：" + e.getMessage());
        }
        return mapList;
    }
}
