package com.huigou.topsun.config;

import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;

import java.io.IOException;
import java.io.OutputStream;

/**
 * CloseableClientHttpRequest ClientHttpRequest 实现 AutoCloseable
 *
 * @author qinzhenguan
 * @createDate 2024/01/17 14:20
 **/
public class CloseableClientHttpRequest implements AutoCloseable {

    private final ClientHttpRequest delegate;

    public CloseableClientHttpRequest(ClientHttpRequest delegate) {
        this.delegate = delegate;
    }

    public ClientHttpRequest getDelegate() {
        return delegate;
    }

    public void addHeader(String name, String value) {
        delegate.getHeaders().add(name, value);
    }

    public OutputStream getBody() throws IOException {
        return delegate.getBody();
    }

    public ClientHttpResponse execute() throws IOException {
        return delegate.execute();
    }

    @Override
    public void close() {

    }
}

// delegate.getBody().close(); // 资源已释放
// delegate.close(); // ClientHttpRequest接口未提供 close 方法