package com.huigou.topsun.base.task.impl;

import com.huigou.context.Operator;
import com.huigou.context.ThreadLocalUtil;
import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.topsun.base.task.BaseTask;
import com.huigou.uasp.bmp.common.application.BaseApplication;
import com.huigou.uasp.bmp.operator.OperatorApplication;
import com.huigou.uasp.bpm.ProcessStatus;
import com.huigou.uasp.bpm.TaskStatus;
import com.huigou.uasp.bpm.engine.application.WorkflowApplication;
import com.huigou.uasp.bpm.engine.domain.model.HistoricTaskInstanceExtension;
import com.huigou.uasp.bpm.engine.domain.model.RuntimeTaskExtension;
import com.huigou.uasp.bpm.engine.repository.HistoricTaskInstanceExtensionRepository;
import com.huigou.uasp.bpm.engine.repository.RuntimeTaskExtensionRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author xin.lu
 * @Description: TODO
 * @date 2025/3/2811:17
 */
@Service("baseTask")
public class BaseTaskImpl extends BaseApplication implements BaseTask {
    @Autowired
    private OperatorApplication operatorApplication;
    @Autowired
    private WorkflowApplication workflowService;
    @Autowired
    private RuntimeTaskExtensionRepository runtimeTaskExtensionRepository;
    @Autowired
    private HistoricTaskInstanceExtensionRepository historicTaskInstanceExtensionRepository;

    @Override
    public String queryTaskByBizId(String bizId) {
        QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_TASK_XML_FILE_PATH, "queryTaskByBizId");
        String sql = queryDescriptor.getSql();
        String taskId = this.sqlExecutorDao.queryToString(sql, bizId);
        return taskId;
    }

    @Override
    public void makeACopyFor(String bizId, String personMemberId, List<String> executorIds, String title) {
        String taskId = this.queryTaskByBizId(bizId);
        Operator operator = operatorApplication.createOperatorByPersonMemberId(personMemberId);
        ThreadLocalUtil.putOperator(operator);
        this.workflowService.makeACopyFor(taskId, executorIds,title);
    }

    @Override
    public List<String> queryHandlersByBizId(String bizId) {
        QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_TASK_XML_FILE_PATH, "queryHandlersByBizId");
        String sql = queryDescriptor.getSql();
        return this.sqlExecutorDao.queryToList(sql, String.class, bizId);
    }

    @Override
    public void deleteRunTimeTaskExtensionByBizId(String bizId) {
        //删除待办任务
        List<String> kindIds = new ArrayList<>();
        kindIds.add("task");
        List<RuntimeTaskExtension> extensionList = runtimeTaskExtensionRepository.findCoordinationTaskInstances(bizId, "process", kindIds);
        if (!CollectionUtils.isEmpty(extensionList)){
            runtimeTaskExtensionRepository.delete(extensionList);
        }
    }

    @Override
    public void updateHistoricTaskInstanceExtensionByBizId(String bizId) {
        //更新任务状态
        List<HistoricTaskInstanceExtension> extensionList = historicTaskInstanceExtensionRepository.findByBusinessKeyAndTaskDefinitionKey(bizId, "Apply");
        if (!CollectionUtils.isEmpty(extensionList)){
            extensionList.forEach(historicTaskInstanceExtension -> {
                if ("back".equals(historicTaskInstanceExtension.getGenerateReason())){
                    historicTaskInstanceExtension.setStatusId(ProcessStatus.ABORTED.getId());
                    historicTaskInstanceExtension.setStatusName(ProcessStatus.ABORTED.getDisplayName());
                    historicTaskInstanceExtension.setEndTime(new Date());
                    historicTaskInstanceExtension.setDeleteReason(TaskStatus.ABORTED.getId());
                    historicTaskInstanceExtensionRepository.save(historicTaskInstanceExtension);
                }
            });
        }
    }
}
