package com.huigou.tech.common.domain;

import java.util.LinkedHashMap;
import java.util.Map;

import org.springframework.util.Assert;

/**
 * 通知类型
 */
public enum TechNoticeKind {
    TEXT("text", "普通文本"), LOAD("load", "AJAX加载页面"), IFRAME("iframe", "IFRAME嵌入页面"), CHART("chart", "流程图");

    private String id;

    private String displayName;

    private TechNoticeKind(String id, String displayName) {
        this.id = id;
        this.displayName = displayName;

    }

    public String getId() {
        return id;
    }

    public String getDisplayName() {
        return displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public static TechNoticeKind fromId(String id) {
        Assert.hasText(id, "无效的通知类型!");
        for (TechNoticeKind c : TechNoticeKind.values()) {
            if (c.getId().equals(id)) {
                return c;
            }
        }
        throw new RuntimeException(String.format("无效的通知类型“%s”！", id));
    }

    public static Map<String, String> getMap() {
        Map<String, String> map = new LinkedHashMap<>(TechNoticeKind.values().length);
        for (TechNoticeKind c : TechNoticeKind.values()) {
            map.put(c.getId(), c.getDisplayName());
        }
        return map;
    }
}
