var gridManager = null;

$(document).ready(function () {
    initUI();
    loadGrid();
})
function initUI() {
    UICtrl.initDefaultLayout();
}

function loadGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
        addHandler: addHandler,
    });
    gridManager = UICtrl.grid("#maingrid", {
        columns: [
            {display: "单据编号", name: "billCode", width: 150, minWidth: 60, type: "string", align: "left"},
            {display: "创建日期", name: "fillinDate", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "申请人", name: "personMemberName", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "申请部门", name: "deptName", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "用途", name: "purposeTextView", width: 200, minWidth: 60, type: "string", align: "left"},
            {display: "原由", name: "reason", width: 200, minWidth: 60, type: "string", align: "left"},
            {display: "需求描述", name: "requireDes", width: 300, minWidth: 60, type: "string", align: "left"},
        ],
        dataAction: "server",
        url: web_app.name + '/produceMaterialApply/slicedProduceMaterialApplyList.ajax',
        pageSize: 20,
        usePager: true,
        toolbar: toolbarOptions,
        width: "100%",
        height: "100%",
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true,
        onDblClickRow: function (data, rowindex, rowobj) {
            doView(data.id);
        },
    });
    UICtrl.setSearchAreaToggle(gridManager);
}

function query(obj) {
    var param = $(obj).formToJSON();
    UICtrl.gridSearch(gridManager, param);
}
function reloadGrid() {
    gridManager.loadData();
}

function resetForm(obj) {
    $(obj).formClean();
}

function addHandler() {
    UICtrl.addTabItem({
        tabid: 'produceMaterialApply',
        text: "新增生产类货源开发申请表",
        url: web_app.name + '/produceMaterialApply/forwardProduceMaterialApplyDetail.job'
    });
}

function doView(id) {
    UICtrl.addTabItem({
        tabid: 'produceMaterialApply'+id,
        text: "查看生产类货源开发申请表",
        url: web_app.name + '/produceMaterialApply/showProduceMaterialApplyDetail.job?bizId='+id+"&isReadOnly=true"
    });
}
