var gridManager = null;

$(document).ready(function () {
    initialize();
    loadGrid();
    bindEvent();
    initUsed($('#kostl').val());
});
function initialize(){
    UICtrl.layout("#layout", {leftWidth: 3});
}

function bindEvent(){
    $('#werksName').searchbox({
        type: "system", name: "dictionary",
        getParam: function (item) {
            return {fieldName: "WERKS"}
        },
        onChange: function (value, data) {
            $('#werks').val(data.WERKS);
            $('#werksName').val(data.NAME1);
        }
    });
    // $('#kostlName').searchbox({
    //     type: "system", name: "queryCostCenter",
    //     onChange: function (value, data) {
    //         $('#kostl').val(data.kostl);
    //         $('#kostlName').val(data.ktext);
    //         if (Public.isNotBlank($('#aufnr').val())){
    //             $('#aufnr').val(null);
    //             $('#aufnrName').val(null);
    //             Public.tip("选择成本中心，不能选择内部订单");
    //         }
    //     }
    // });
    $('#kostlName').searchbox({
        type: "system", name: "dictionary",
        getParam: function (item) {
            return {
                fieldName: "KOSTL"
            }
        },
        onChange: function (value, data) {
            $('#kostl').val(data.KOSTL);
            $('#kostlName').val(data.LTEXT);
            if (Public.isNotBlank($('#aufnr').val())){
                $('#aufnr').val(null);
                $('#aufnrName').val(null);
                Public.tip("选择成本中心，不能选择内部订单");
            }
            setTimeout(function () {
                initUsed(data.KOSTL);
            }, 100)
        }
    });
    $('#aufnrName').searchbox({
        type: "system", name: "getCompanyOrders",
        getParam: function (item) {
            return {
                BUKRS: $("#werks").val()
            }
        },
        onChange: function (value, data) {
            $('#aufnr').val(data.AUFNR);
            $('#aufnrName').val(data.KTEXT);
            if (Public.isNotBlank($('#kostl').val())){
                $('#kostl').val(null);
                $('#kostlName').val(null);
                Public.tip("选择内部订单，不能选择成本中心");
            }
            setTimeout(function () {
                initUsed("");
            }, 100)
        }
    });
}

function loadGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
        addHandler: function () {
            UICtrl.addGridRow(gridManager,{ rspos: (gridManager.getData().length + 1)});
        },
        deleteHandler: function () {
            var _grid = UICtrl.getGridManager('#maingrid');
            DataUtil.delSelectedRows({
                action: 'nonProducePickItem/deleteNonProducePickItem.ajax',
                param: {nonProducePickId:$("#id").val()},
                gridManager: _grid,
                idFieldName: 'id',
                onSuccess: function () {
                    reloadGrid();
                }
            });
        }
    });
    gridManager = UICtrl.grid("#maingrid", {
        columns: [
            {
                display: "序号", name: "rspos", width: 70, minWidth: 60, type: "string", align: "left",
            },
            {
                display: "物料组", name: "wgbez", width: 160, align: "left", type: "string",
                editor: {
                    required: true, type: "select",
                    data: {
                        type: 'system',
                        name: "dictionary",
                        getParam: function (item) {
                            return {
                                fieldName: "MATKL",
                                //filterValue: $("#werks").val()
                            }
                        },
                        back: {
                            MATKL: "matkl",
                            WGBEZ: "wgbez",
                        }
                    },
                }
            },
            {
                display: "物料", name: "matnr", width: 160, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: true, type: "select",
                    data: {
                        type: 'system',
                        name: "sapMaterialSelect",
                        getParam: function (item) {
                            return {
                                filterValue:$("#werks").val(),
                                matkl:item.matkl,
                                mtart:"ZGMB",
                                ztype:"X",
                                ztype2:"N",
                            }
                        },
                        back: {
                            MATNR: "matnr",
                            MAKTX: "maktx",
                            MEINS: "meins",
                            MSEHL: "msehl",
                            MATXT: "matxt",
                            MATKL: "matkl",
                            WGBEZ: "wgbez",
                        }
                    },
                }
            },
            {
                display: "SAP物料名称", name: "maktx", width: 300, minWidth: 60, type: "string", align: "left",
                editor: {
                    type: "text"
                }
            },
            {
                display: "物料要求描述", name: "matxt", width: 300, minWidth: 60, type: "string", align: "left",
                editor: {
                    type: "text"
                }
            },
            {
                display: "库存地点", name: "lgobe", width: 200, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: false, type: "select",
                    data: {
                        type: 'system',
                        name: "dictionary",
                        getParam: function (item) {
                            return {
                                fieldName: "LGORT",
                                filterValue: $("#werks").val()
                            }
                        },
                        back: {
                            LGORT: "lgort",
                            LGOBE: "lgobe"
                        }
                    },
                }
            },
            {
                display: "数量", name: "erfmg", width: 100, minWidth: 60, type: "string", align: "left",
                editor: {
                    type: "text",mask: '9999999.99',required: true
                }
            },
            {
                display: "计量单位", name: "msehl", width: 90, minWidth: 60, type: "string", align: "left",
                // editor: {
                //     type: "text"
                // }
            },
            {
                display: "领料方", name: "wempf", width: 200, minWidth: 60, type: "string", align: "left",
                editor: {type: "text",maxLength:500 }
            },
            {
                display: "备注用途", name: "usedTextView", width: 200, minWidth: 60, type: "string", align: "left",
                editor: {
                    type: 'dictionary',
                    data: {name: 'used'},
                    textField: 'usedTextView',
                    valueField: 'used',
                    required: true,
                    render: function (item) {
                        return item.usedTextView;
                    }
                },
            },
            // {
            //    display: "", name: "remark", width: 300, minWidth: 60, type: "string", align: "left",
            //     editor: { type: "text",maxLength:1000 }
            // }
        ],
        dataAction: "server",
        url: web_app.name + '/nonProducePickItem/queryNonProducePickItems.ajax',
        pageSize: 10,
        usePager: true,
        parms:{nonProducePickId:getId()},
        toolbar: toolbarOptions,
        enabledEdit: true,
        width: "100%",
        height: "100%",
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true,
        onBeforeEdit: function (editParm) {
            var c = editParm.column, data = editParm.record;
            if (c.name == 'matnr' && Public.isBlank($("#werks").val())) {
                Public.tip("请先选择工厂");
                return false;
            }
        }
    });
    UICtrl.setSearchAreaToggle(gridManager);
}

function initUsed(kostl){
    var columns = gridManager.columns;
    columns.some(column => {
        if (column.name == "used"){
            column.editor.required = Public.isNotBlank(kostl)? true:false;
            //return true;
        }
        //return false;
    })

    columns.splice(0,1)
    UICtrl.setGridColumns(gridManager,columns);
}

/**
 * 流程引擎回调设置打样的id
 * @param value 打样申请的id
 */
function setId(id) {
    $("#id").val(id);

    var _grid=UICtrl.getGridManager('#maingrid');
    _grid.options.parms.nonProducePickId = id;
}

/**
 * 流程引擎获取打样申请id的回掉方法。
 * @return 打样申请的id
 */
function getId() {
    return $("#id").val() || "";
}

function reloadGrid() {
    gridManager.loadData();
}

function getExtendedData(processAction) {
//回退、打回、转交时，不需要验证必填项是否已经填写；
    if (processAction == ProcessAction.BACK
        || processAction == ProcessAction.REPLENISH
        || processAction == ProcessAction.TRANSMIT) {
//不验证
        $('#submitForm').attr('check', false);
    }
    var extendedData = {};
    var _grid = UICtrl.getGridManager('#maingrid');
    if (_grid) {
        var datas = DataUtil.getGridData({
            gridManager: _grid,
            isAllData: true
        });
        if (!datas) {
            return false;
        }
        // if (datas.length == 0){
        //     Public.tip("请添加领料明细");
        //     return false
        // }
        extendedData.items = Public.encodeJSONURI(datas);
    }
    return extendedData;
}

function checkConstraints(){
    var kostlName = $("#kostlName").val();
    var aufnrName = $("#aufnrName").val();
    if (Public.isBlank(kostlName) && Public.isBlank(aufnrName)){
        Public.tip("请选择成本中心或内部订单");
        return false;
    }
    return true;
}
