var gridManager = null;

$(document).ready(function () {
    initializateUI();
    loadCostCenterListGrid();
});


function initializateUI() {
    UICtrl.layout("#layout", {leftWidth: 3});
    $('#supplierName').searchbox({
        type: "system", name: "selectSuppliersDatas",
        getParam: function (item) {
            return {
                ///  fieldName: "sapMaterialSelect",
                filterValue: $('#werks').val()
            }
        },
        onChange: function (value, data) {
            $('#supplier').val(data.partner);
            $('#supplierName').val(data.nameOrg1);
        }
    });
}

function loadCostCenterListGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
        addHandler: function () {
            addHandler();
        },
        deleteHandler: deleteHandler,
    });
    gridManager = UICtrl.grid("#maingrid", {
        columns: [
            {display: "品名", name: "productName", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "数量", name: "number", width: 80, minWidth: 60, type: "string", align: "left"},
            {display: "单位", name: "unitName", width: 80, minWidth: 60, type: "string", align: "left"},
            {display: "是否收费", name: "isChargeTextView", width: 80, minWidth: 60, type: "string", align: "left"},
            {display: "工厂", name: "werksName", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "库存地点", name: "storeName", width: 100, minWidth: 60, type: "string", align: "left"},
            {display: "供应商", name: "supplierName", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "申请人", name: "personMemberName", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "申请部门", name: "deptName", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "申请日期", name: "fillinDate", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "单据编号", name: "billCode", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "事由", name: "reason", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "状态", name: "statusTextView", width: 60, minWidth: 60, type: "string", align: "center",},
            {display: "消息类型", name: "type", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "消息文本", name: "message", width: 200, minWidth: 60, type: "string", align: "left"},
        ],
        dataAction: "server",
        _tableKey: 'nonOrderStorage',
        _local: true,
        url: web_app.name + '/nonOrderStorage/slicedNonOrderStorageList.ajax',
        pageSize: 20,
        usePager: true,
        toolbar: toolbarOptions,
        width: "100%",
        height: "100%",
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true,
        // 双击执行
        onDblClickRow: function (data, rowindex, rowobj) {
            updateHandler(data);
        }
    });
    UICtrl.setSearchAreaToggle(gridManager);
}

function query(obj) {
    var param = $(obj).formToJSON();
    UICtrl.gridSearch(gridManager, param);
}

function reloadGrid() {
    gridManager.loadData();
}

function resetForm(obj) {
    $(obj).formClean();
}

function addHandler() {
    UICtrl.addTabItem({
        tabid: 'nonOrderStorageDetail',
        text: "新增无订单库存入库",
        url: web_app.name + '/nonOrderStorage/addNonOrderStorageDetail.job'
    })
}

function updateHandler(row) {
    if (!row) {
        row = DataUtil.getUpdateRow(gridManager);
        if (!row) {
            return;
        }
    }
    UICtrl.addTabItem({
        tabid: 'nonOrderStorageDetail',
        text: "查看无订单库存入库",
        url: web_app.name + '/nonOrderStorage/showNonOrderStorageDetail.job?isReadOnly=true&bizId=' + row.id
    })
}

//删除按钮
function deleteHandler() {
    DataUtil.del({
        action: 'nonOrderStorage/deleteNonOrderStorageById.ajax',
        gridManager: gridManager, idFieldName: 'id',
        onSuccess: function () {
            reloadGrid();
        }
    });
}

