<%--采购申请--%>
<%@ page contentType="text/html; charset=utf-8" language="java" %>
<%@ taglib uri="/WEB-INF/taglib.tld" prefix="x" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<html>
<head>
    <x:base include="layout,dialog,grid,tree,dateTime,combox,attachment,commonTree,comboDialog"/>
    <x:script src="/biz/topsun/sap/exceptionReport/exceptionReportDetailSupplier.js"/>
</head>
<body>
<div class="container-fluid">
    <x:billTitle title="品质异常报告(供应商)" needStatus="true" needPerson="true"/>
    <form class="hg-form" method="post" action="" id="submitForm">
        <x:hidden name="billType"/>
        <x:hidden name="id"/>
        <x:hidden name="version"/>
        <x:hidden name="attbizId"/>
        <x:hidden name="billCode"/>
        <x:hidden name="fillinDate"/>
        <x:hidden name="fullId"/>
        <x:hidden name="organId"/>
        <x:hidden name="organName"/>
        <x:hidden name="deptId"/>
        <x:hidden name="deptName"/>
        <x:hidden name="positionId"/>
        <x:hidden name="positionName"/>
        <x:hidden name="personMemberId"/>
        <x:hidden name="personMemberName"/>
        <x:hidden name="exceptionType" value="out"/>
        <x:hidden name="frgdt"/>
        <x:hidden name="werks"/>
        <x:hidden name="werksName"/>
        <x:hidden name="manager"/>
        <x:hidden name="deputyManager"/>
        <x:hidden name="generalManager"/>
        <x:hidden name="generalManager"/>
        <x:hidden name="checkOperator"/>
        <x:hidden name="checkOperatorName"/>
        <x:hidden name="dutyDept"/>
        <x:hidden name="dutyDeptName"/>
        <x:hidden name="sourceBillCode"/>
         <div class="hg-form-cols">
            <c:if test="${statusId==1||statusId==3}">
            <div style="float: right; margin-right: 10px;" class="btn-group" id="buttonBox">
                <button id="save" title="" type="button" onclick="printPage()" class="btn btn-gray"><i
                        class="fa fa-save"></i>打印
                </button>
            </div>
            </c:if>
                <div class="hg-form-row">
            <x:inputC name="exceptionTitle" label="异常标题" labelCol="1" fieldCol="11" required="true"/>
                </div>
            <div class="hg-form-row">
                <!--x:selectC name="exceptionType" label="异常类型" labelCol="1" fieldCol="2" required="true" dictionary="exceptionType"/-->
                <x:inputC name="exceptionDate" label="异常日期" labelCol="1" fieldCol="2" required="true" wrapper="date"/>
                <x:inputC name="reportDate" label="呈报日期" labelCol="1" fieldCol="2" required="true" wrapper="date"/>
                <x:selectC name="exceptionReasonType" label="异常原因分类" labelCol="1" fieldCol="2" required="false"  disabled="true" dictionary="exceptionReasonType"/>

                <x:hidden name="customerNo"/>
                <x:inputC name="customerName" required="true" label="供应商名称" labelCol="1" wrapper="select" fieldCol="2"/>
            </div>
            <div class="hg-form-row">
                <x:inputC name="matnr" label="材料编码" labelCol="1" fieldCol="2" required="false" readonly="true"/>
                <x:inputC name="maktx" label="材料名称" labelCol="1" fieldCol="2" required="false"  readonly="true"/>

                <x:inputC name="customerOrderNo" label="采购单号" labelCol="1" fieldCol="2" required="false"  readonly="true"/>

                <x:inputC name="loseMoney" label="损失金额" labelCol="1" fieldCol="2" required="true" mask="nnnnnn.nn" />
                <x:selectC name="statusId" label="处理进度" labelCol="1" fieldCol="2" disabled="true" required="false" dictionary="bizBillStatus"/>
                <x:inputC name="sapBillNo" label="SAP单据号" labelCol="1" fieldCol="2" required="false" readonly="true"/>
            </div>
            <div class="hg-form-row">
                <x:textareaC name="exceptionState" required="false" label="异常描述" maxLength="2500" labelCol="1" fieldCol="11" rows="3"/>
            </div>
        </div>
        <div class="hg-form-cols" >
        <div class="hg-form-row">
            <x:radioC name="dealWay" label="处理方式" labelCol="1" fieldCol="11" required="true" dictionary="dealWay" disabled="false"/>
        </div>
        </div>
        <div class="hg-form-cols" id="payDiv">
          <x:title title="处理方式:货币结算（扣除应付款）" name="group" hideTable="#maingrid1" />
          <div id="maingrid1"></div>
        </div>
        <div class="hg-form-cols" id="cashDiv">
        <x:title title="处理方式:货币结算（现金/转账）" name="group" hideTable="#maingrid2"  />
        <div id="maingrid2"></div>
        </div>
        <div class="hg-form-cols" id="goodsDiv">
        <x:title title="处理方式:商品结算" name="group" hideTable="#maingrid3"  />
        <div id="maingrid3"></div>
        </div>
        <div class="hg-form-cols" id="specialDiv">
        <x:title title="处理方式:特殊处理" name="group"/>
        <div class="hg-form-cols">
          <div class="hg-form-row">
            <x:textareaC name="dealMethod" required="false" label="特殊处理" maxLength="1500" labelCol="1" fieldCol="11" rows="2" readonly="false"/>
          </div>
        </div>
        </div>
        <div class="hg-form-cols">
            <div class="hg-form-row">
                <x:textareaC name="dealResult" required="false" label="处理结果" maxLength="1500" labelCol="1" fieldCol="11" rows="2" readonly="false"/>
            </div>
            <div class="hg-form-row">
                <x:textareaC name="remark" required="false" label="备注" maxLength="800" labelCol="1" fieldCol="11" rows="2"/>
            </div>
        </div>
        <div style="padding-top: 15px;">
            <x:fileList bizCode="exceptionStateInfo" bizId="attbizId" id="exceptionStateInfoList" title="相关资料"/>
        </div>
   </form>
</div>
</body>