var gridManager = null;

$(document).ready(function () {

    initializateUI();
    loadGrid();
})
function initializateUI() {
    UICtrl.layout("#layout", {leftWidth: 3});
}

function loadGrid() {

    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
        addAdvancePayment: {id:'advancePayment',img:'fa-cog',text:'添加预付款申请',click:function(){
                addAdvancePayment();
        }},

    });
    gridManager = UICtrl.grid("#advancePaymentListGrid", {
        columns: [
            {display: "EP流程单号", name: "zepNo", width: 100, minWidth: 60, type: "string", align: "left"},
            {display: "审批状态", name: "statusTextView", width: 100, minWidth: 60, type: "string", align: "left"},
            {display: "付款凭证编号", name: "belnr1", width: 120, minwidth: 120, type: "string", align: "left"},
            {display: "付款凭证财年", name: "gjahr1", width: 120, minwidth: 120, type: "string", align: "left"},
            {display: "付款状态", name: "zpayStaus", width: 120, minwidth: 120, type: "string", align: "left"},
            {display: "EP付款申请类别名称", name: "zepFtypename", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "公司代码", name: "bukrs", width: 80, minWidth: 60, type: "string", align: "left"},
            {display: "公司代码名称", name: "butxt", width: 200, minWidth: 60, type: "string", align: "left"},
            {display: "EP部门名称", name: "zepDepartname", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "EP流程申请人", name: "zepAppliname", width: 100, minWidth: 60, type: "string", align: "left"},
            {display: "付款申请内容", name: "zepTxt", width: 200, minWidth: 60, type: "string", align: "left"},
            {display: "填报日期", name: "fillinDate", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "申请总金额", name: "zepFtamount1", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "EP流程子序号", name: "zepItemno", width: 80, minwidth: 80, type: "string", align: "left"},
            {
                display: "计划内外付款标识", name: "zepPlan", width: 120, minwidth: 120, type: "string", align: "left",
            },
            {
                display: "计划内外标识名称",
                name: "zepPlanname",
                width: 120,
                minwidth: 120,
                type: "string",
                align: "left",
            },
            {
                display: "BP标识", name: "zepBptype", width: 100, minwidth: 120, type: "string", align: "left"
            },
            {
                display: "BP标识描述", name: "zepBptypename", width: 120, minwidth: 120, type: "string", align: "left",
            },
            {
                display: "BP(合作伙伴)", name: "partner", width: 120, minwidth: 120, type: "string", align: "left",
            },
            {
                display: "BP账号名称", name: "koinh", width: 200, minwidth: 120, type: "string", align: "left",
            },
            {
                display: "BP银行账号", name: "bankn", width: 200, minwidth: 120, type: "string", align: "left",
            },
            {
                display: "BP联行号", name: "bankl", width: 120, minwidth: 120, type: "string", align: "left",
            },
            {
                display: "SWIFT/BIC", name: "swift", width: 120, minwidth: 120, type: "string", align: "left",
            },
            {
                display: "采购订单号", name: "ebeln", width: 120, minwidth: 120, type: "string", align: "left",
            },
            {
                display: "采购订单行", name: "ebelp", width: 120, minwidth: 120, type: "string", align: "left",
            },
            {
                display: "采购订单行信息", name: "zekpoItem", width: 300, minwidth: 120, type: "string", align: "left",
            },
            {
                display: "币别", name: "waers", width: 120, minwidth: 120, type: "string", align: "left",
            },
            {
                display: "汇率", name: "kursf", width: 120, minwidth: 120, type: "string", align: "left",
            },
            {
                display: "含税金额", name: "kzwi1", width: 120, minwidth: 120, type: "money", align: "left",
            },
            {
                display: "含税金额（本位币）", name: "kzwi11", width: 120, minwidth: 120, type: "money", align: "left",
            },
            {
                display: "是否付款", name: "zepPay", width: 120, minwidth: 120, type: "string", align: "left",
            },
            {
                display: "原因代码", name: "rstgrName", width: 200, minwidth: 120, type: "string", align: "left",
            },
            {
                display: "含税金额（审批）",
                name: "zepPtdamount1",
                width: 120,
                minwidth: 120,
                type: "money",
                align: "left",
            },
            {
                display: "含税金额（审批-本位币）",
                name: "zepPtdamount",
                width: 120,
                minwidth: 120,
                type: "money",
                align: "left",
            },
            {display: "", name: "zlsch", width: 80, minwidth: 80, type: "string", align: "left", hide: true},
            {
                display: "付款方式", name: "zlschTextView", width: 150, minwidth: 120, type: "string", align: "left",
            },
            {
                display: "直联付款标识", name: "zepBank", width: 120, minwidth: 120, type: "string", align: "left",
            },
            {display: "记账凭证编号", name: "belnr", width: 120, minwidth: 120, type: "string", align: "left"},
            {display: "记账凭证财年", name: "gjahr", width: 120, minwidth: 120, type: "string", align: "left"},
            {display: "记账过账日期", name: "budat", width: 120, minwidth: 120, type: "string", align: "left"},
            {display: "记账凭证日期", name: "bldat", width: 120, minwidth: 120, type: "string", align: "left"},
            {display: "返回状态", name: "msgty", width: 120, minwidth: 120, type: "string", align: "left"},
            {display: "返回消息", name: "msgtx", width: 300, minwidth: 120, type: "string", align: "left"}

        ],
        dataAction: "server",
        url: web_app.name + '/sapCostReimbursement/slicedAdvancePaymentList.ajax',
        parms:{zepFtype:"D"},
        pageSize: 20,
        usePager: true,
        sortName: "fillinDate",
        sortOrder: "desc",
        toolbar: toolbarOptions,
        width: "100%",
        height: "100%",
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true,
        onDblClickRow: function (data, rowindex, rowobj) {
            doView(data.bizId,data.zepFtype);
        }

    });
    UICtrl.setSearchAreaToggle(gridManager);
}

function query(obj) {
    var param = $(obj).formToJSON();
    UICtrl.gridSearch(gridManager, param);
}
function reloadGrid() {
    gridManager.loadData();
}

function resetForm(obj) {
    $(obj).formClean();
}


//重写DataUtil的getUpdateRowId函数、它默认取行的id列
DataUtil.getUpdateRowId = function (gridManager) {
    var result = DataUtil.getUpdateRow(gridManager);
    if (result) {
        return result.proofingMakeId;
    }
    return result;
}

function addAdvancePayment(){
    UICtrl.addTabItem({
        tabid: 'advanceApply',
        text: "预付款申请单",
        url: web_app.name + '/sapCostReimbursement/forwardCostReimbursement.job?type=advance'
    });
}

//删除按钮
function deleteHandler() {
    DataUtil.del({
        action: 'sapCostReimbursement/deleteStatsIndicators.ajax',
        gridManager: gridManager, idFieldName: 'id',
        onSuccess: function () {
            reloadGrid();
        }
    });
}



function doView(id,zepFtype) {
    var title="费用报销详情";
    if (zepFtype=="E"){
        title="客户退款申请详情";
    }
    if (zepFtype=="B"){
        title="员工借款申请详情";
    }
    if (zepFtype=="D"){
        title="预付款申请详情";
    }
    if (zepFtype=="C"){
        title="付款申请详情";
    }
    UICtrl.addTabItem({
        tabid: 'showCostReimbursement'+id,
        text: title,
        url: web_app.name + '/sapCostReimbursement/showSapCostReimbursement.job?bizId='+id+"&isDetailPage=true"
    });
}

// function sendSapData(bizId){
//     Public.ajax(web_app.name + '/sapStatsIndicators/againSendSapDate.ajax',{bizId:bizId},function (data){
//         reloadGrid();
//     })
// }